/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.bc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.bc.ECKeyUtil;

public class PemUtil {
    public static PrivateKey readPemPrivateKey(InputStream pemStream) {
        return (PrivateKey)PemUtil.readPemKey(pemStream);
    }

    public static PublicKey readPemPublicKey(InputStream pemStream) {
        return (PublicKey)PemUtil.readPemKey(pemStream);
    }

    public static Key readPemKey(InputStream keyStream) {
        PemObject object = PemUtil.readPemObject(keyStream);
        String type = object.getType();
        if (StrUtil.isNotBlank((CharSequence)type)) {
            if (type.endsWith("EC PRIVATE KEY")) {
                try {
                    return KeyUtil.generatePrivateKey("EC", object.getContent());
                }
                catch (Exception e) {
                    return KeyUtil.generatePrivateKey("EC", ECKeyUtil.createOpenSSHPrivateKeySpec(object.getContent()));
                }
            }
            if (type.endsWith("PRIVATE KEY")) {
                return KeyUtil.generateRSAPrivateKey(object.getContent());
            }
            if (type.endsWith("EC PUBLIC KEY")) {
                try {
                    return KeyUtil.generatePublicKey("EC", object.getContent());
                }
                catch (Exception ignore) {
                    return KeyUtil.generatePublicKey("EC", ECKeyUtil.createOpenSSHPublicKeySpec(object.getContent()));
                }
            }
            if (type.endsWith("PUBLIC KEY")) {
                return KeyUtil.generateRSAPublicKey(object.getContent());
            }
            if (type.endsWith("CERTIFICATE")) {
                return KeyUtil.readPublicKeyFromCert(IoUtil.toStream((byte[])object.getContent()));
            }
        }
        return null;
    }

    public static byte[] readPem(InputStream keyStream) {
        PemObject pemObject = PemUtil.readPemObject(keyStream);
        if (null != pemObject) {
            return pemObject.getContent();
        }
        return null;
    }

    public static PemObject readPemObject(InputStream keyStream) {
        return PemUtil.readPemObject(IoUtil.toUtf8Reader((InputStream)keyStream));
    }

    public static PemObject readPemObject(Reader reader) {
        PemObject pemObject;
        PemReader pemReader = null;
        try {
            pemReader = new PemReader(reader);
            pemObject = pemReader.readPemObject();
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{pemReader});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{pemReader});
        return pemObject;
    }

    public static String toPem(String type, byte[] content) {
        StringWriter stringWriter = new StringWriter();
        PemUtil.writePemObject(type, content, stringWriter);
        return stringWriter.toString();
    }

    public static void writePemObject(String type, byte[] content, OutputStream keyStream) {
        PemUtil.writePemObject((PemObjectGenerator)new PemObject(type, content), keyStream);
    }

    public static void writePemObject(String type, byte[] content, Writer writer) {
        PemUtil.writePemObject((PemObjectGenerator)new PemObject(type, content), writer);
    }

    public static void writePemObject(PemObjectGenerator pemObject, OutputStream keyStream) {
        PemUtil.writePemObject(pemObject, IoUtil.toUtf8Writer((OutputStream)keyStream));
    }

    public static void writePemObject(PemObjectGenerator pemObject, Writer writer) {
        PemWriter pemWriter = new PemWriter(writer);
        try {
            pemWriter.writeObject(pemObject);
        }
        catch (IOException e) {
            try {
                throw new IORuntimeException((Throwable)e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{pemWriter});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{pemWriter});
    }
}

