/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.bc;

import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.spec.OpenSSHPrivateKeySpec;
import org.bouncycastle.jcajce.spec.OpenSSHPublicKeySpec;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.BigIntegers;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.KeyUtil;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.bc.ECKeySpecUtil;
import org.dromara.hutool.crypto.bc.SM2Constant;

public class ECKeyUtil {
    public static ECPublicKeyParameters getPublicParams(ECPrivateKeyParameters privateKeyParameters) {
        ECDomainParameters domainParameters = privateKeyParameters.getParameters();
        org.bouncycastle.math.ec.ECPoint q = new FixedPointCombMultiplier().multiply(domainParameters.getG(), privateKeyParameters.getD());
        return new ECPublicKeyParameters(q, domainParameters);
    }

    public static PublicKey getECPublicKey(ECPrivateKey privateKey, org.bouncycastle.jce.spec.ECParameterSpec spec) {
        ECPublicKeySpec keySpec = new ECPublicKeySpec(ECKeyUtil.getQFromD(privateKey.getD(), spec), spec);
        return KeyUtil.generatePublicKey("EC", (KeySpec)keySpec);
    }

    public static org.bouncycastle.math.ec.ECPoint getQFromD(BigInteger d, org.bouncycastle.jce.spec.ECParameterSpec spec) {
        return spec.getG().multiply(d).normalize();
    }

    public static byte[] encodeECPrivateKey(PrivateKey privateKey) {
        return ((ECPrivateKey)privateKey).getD().toByteArray();
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey) {
        return ECKeyUtil.encodeECPublicKey(publicKey, true);
    }

    public static byte[] encodeECPublicKey(PublicKey publicKey, boolean isCompressed) {
        return ((BCECPublicKey)publicKey).getQ().getEncoded(isCompressed);
    }

    public static PublicKey decodeECPoint(String encode, String curveName) {
        return ECKeyUtil.decodeECPoint(SecureUtil.decode(encode), curveName);
    }

    public static PublicKey decodeECPoint(byte[] encodeByte, String curveName) {
        X9ECParameters x9ECParameters = ECUtil.getNamedCurveByName((String)curveName);
        ECCurve curve = x9ECParameters.getCurve();
        ECPoint point = EC5Util.convertPoint((org.bouncycastle.math.ec.ECPoint)curve.decodePoint(encodeByte));
        ECNamedCurveSpec ecSpec = new ECNamedCurveSpec(curveName, curve, x9ECParameters.getG(), x9ECParameters.getN());
        return KeyUtil.generatePublicKey("EC", new java.security.spec.ECPublicKeySpec(point, (ECParameterSpec)ecSpec));
    }

    public static AsymmetricKeyParameter toParams(Key key) {
        if (key instanceof PrivateKey) {
            return ECKeyUtil.toPrivateParams((PrivateKey)key);
        }
        if (key instanceof PublicKey) {
            return ECKeyUtil.toPublicParams((PublicKey)key);
        }
        return null;
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] q) {
        return ECKeyUtil.toPublicParams(q, SM2Constant.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String q) {
        return ECKeyUtil.toPublicParams(q, SM2Constant.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(String x, String y) {
        return ECKeyUtil.toPublicParams(x, y, SM2Constant.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toSm2PublicParams(byte[] xBytes, byte[] yBytes) {
        return ECKeyUtil.toPublicParams(xBytes, yBytes, SM2Constant.SM2_DOMAIN_PARAMS);
    }

    public static ECPublicKeyParameters toPublicParams(String x, String y, ECDomainParameters domainParameters) {
        return ECKeyUtil.toPublicParams(SecureUtil.decode(x), SecureUtil.decode(y), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(byte[] xBytes, byte[] yBytes, ECDomainParameters domainParameters) {
        if (null == xBytes || null == yBytes) {
            return null;
        }
        return ECKeyUtil.toPublicParams(BigIntegers.fromUnsignedByteArray((byte[])xBytes), BigIntegers.fromUnsignedByteArray((byte[])yBytes), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(BigInteger x, BigInteger y, ECDomainParameters domainParameters) {
        if (null == x || null == y) {
            return null;
        }
        ECCurve curve = domainParameters.getCurve();
        return ECKeyUtil.toPublicParams(curve.createPoint(x, y), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(String pointEncoded, ECDomainParameters domainParameters) {
        ECCurve curve = domainParameters.getCurve();
        return ECKeyUtil.toPublicParams(curve.decodePoint(SecureUtil.decode(pointEncoded)), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(byte[] pointEncoded, ECDomainParameters domainParameters) {
        ECCurve curve = domainParameters.getCurve();
        return ECKeyUtil.toPublicParams(curve.decodePoint(pointEncoded), domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(org.bouncycastle.math.ec.ECPoint point, ECDomainParameters domainParameters) {
        return new ECPublicKeyParameters(point, domainParameters);
    }

    public static ECPublicKeyParameters toPublicParams(PublicKey publicKey) {
        if (null == publicKey) {
            return null;
        }
        try {
            return (ECPublicKeyParameters)ECUtil.generatePublicKeyParameter((PublicKey)publicKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(String d) {
        return ECKeyUtil.toPrivateParams(d, SM2Constant.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(byte[] d) {
        return ECKeyUtil.toPrivateParams(d, SM2Constant.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toSm2PrivateParams(BigInteger d) {
        return ECKeyUtil.toPrivateParams(d, SM2Constant.SM2_DOMAIN_PARAMS);
    }

    public static ECPrivateKeyParameters toPrivateParams(String d, ECDomainParameters domainParameters) {
        if (null == d) {
            return null;
        }
        return ECKeyUtil.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])Objects.requireNonNull(SecureUtil.decode(d))), domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(byte[] d, ECDomainParameters domainParameters) {
        if (null == d) {
            return null;
        }
        return ECKeyUtil.toPrivateParams(BigIntegers.fromUnsignedByteArray((byte[])d), domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(BigInteger d, ECDomainParameters domainParameters) {
        if (null == d) {
            return null;
        }
        return new ECPrivateKeyParameters(d, domainParameters);
    }

    public static ECPrivateKeyParameters toPrivateParams(PrivateKey privateKey) {
        if (null == privateKey) {
            return null;
        }
        try {
            return (ECPrivateKeyParameters)ECUtil.generatePrivateKeyParameter((PrivateKey)privateKey);
        }
        catch (InvalidKeyException e) {
            throw new CryptoException(e);
        }
    }

    public static PrivateKey generatePrivateKey(ASN1Encodable privateKey) {
        try {
            PrivateKeyInfo info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, (ASN1Encodable)SM2Constant.ID_SM2_PUBLIC_KEY_PARAM), privateKey);
            return KeyUtil.generatePrivateKey("SM2", info.getEncoded());
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static PrivateKey generateSm2PrivateKey(byte[] privateKeyBytes) {
        if (null == privateKeyBytes) {
            return null;
        }
        String algorithm = "SM2";
        try {
            ECPrivateKeySpec keySpec = ECKeySpecUtil.getPrivateKeySpec(privateKeyBytes, SM2Constant.SM2_EC_SPEC);
            return KeyUtil.generatePrivateKey("SM2", (KeySpec)keySpec);
        }
        catch (Exception exception) {
            try {
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
                return KeyUtil.generatePrivateKey("SM2", keySpec);
            }
            catch (Exception exception2) {
                OpenSSHPrivateKeySpec keySpec = ECKeySpecUtil.getOpenSSHPrivateKeySpec(privateKeyBytes);
                return KeyUtil.generatePrivateKey("SM2", (KeySpec)keySpec);
            }
        }
    }

    public static PublicKey generateSm2PublicKey(byte[] publicKeyBytes) {
        if (null == publicKeyBytes) {
            return null;
        }
        String algorithm = "SM2";
        try {
            ECPublicKeySpec keySpec = ECKeySpecUtil.getPublicKeySpec(publicKeyBytes, SM2Constant.SM2_EC_SPEC);
            return KeyUtil.generatePublicKey("SM2", (KeySpec)keySpec);
        }
        catch (Exception exception) {
            try {
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(publicKeyBytes);
                return KeyUtil.generatePublicKey("SM2", keySpec);
            }
            catch (Exception exception2) {
                OpenSSHPublicKeySpec keySpec = ECKeySpecUtil.getOpenSSHPublicKeySpec(publicKeyBytes);
                return KeyUtil.generatePublicKey("SM2", (KeySpec)keySpec);
            }
        }
    }

    public static PublicKey generateSm2PublicKey(byte[] x, byte[] y) {
        if (null == x || null == y) {
            return null;
        }
        return KeyUtil.generatePublicKey("sm2", (KeySpec)ECKeySpecUtil.getPublicKeySpec(x, y, SM2Constant.SM2_EC_SPEC));
    }
}

