/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric.paillier;

import java.security.Key;
import java.security.KeyPair;
import java.security.SecureRandom;
import org.dromara.hutool.crypto.CipherMode;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.asymmetric.AbstractAsymmetricCrypto;
import org.dromara.hutool.crypto.asymmetric.KeyType;
import org.dromara.hutool.crypto.asymmetric.paillier.PaillierCipher;
import org.dromara.hutool.crypto.asymmetric.paillier.PaillierKeyPairGenerator;

public class PaillierCrypto
extends AbstractAsymmetricCrypto<PaillierCrypto> {
    private static final long serialVersionUID = 1L;
    private final PaillierCipher cipher = new PaillierCipher();
    private SecureRandom random;

    public PaillierCrypto() {
        this(PaillierKeyPairGenerator.of().generateKeyPair());
    }

    public PaillierCrypto(KeyPair keyPair) {
        super("Paillier", keyPair);
    }

    public PaillierCrypto setRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            this.initMode(CipherMode.ENCRYPT, key);
            byte[] byArray = this.doFinal(data, 0, data.length);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] decrypt(byte[] bytes, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            this.initMode(CipherMode.DECRYPT, key);
            byte[] byArray = this.doFinal(bytes, 0, bytes.length);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public PaillierCrypto initMode(CipherMode mode, Key key) {
        this.cipher.init(mode, new PaillierCipher.PaillierParameters(key, this.random));
        return this;
    }

    public byte[] doFinal(byte[] input, int inputOffset, int inputLen) {
        return this.cipher.processFinal(input, inputOffset, inputLen);
    }
}

