/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.symmetric;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;

public interface SymmetricEncryptor {
    public byte[] encrypt(byte[] var1);

    public void encrypt(InputStream var1, OutputStream var2, boolean var3);

    default public String encryptHex(byte[] data) {
        return HexUtil.encodeStr((byte[])this.encrypt(data));
    }

    default public String encryptBase64(byte[] data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    default public byte[] encrypt(String data, Charset charset) {
        return this.encrypt(ByteUtil.toBytes((CharSequence)data, (Charset)charset));
    }

    default public String encryptHex(String data, Charset charset) {
        return HexUtil.encodeStr((byte[])this.encrypt(data, charset));
    }

    default public String encryptBase64(String data, Charset charset) {
        return Base64.encode((byte[])this.encrypt(data, charset));
    }

    default public byte[] encrypt(String data) {
        return this.encrypt(ByteUtil.toBytes((CharSequence)data, (Charset)CharsetUtil.UTF_8));
    }

    default public String encryptHex(String data) {
        return HexUtil.encodeStr((byte[])this.encrypt(data));
    }

    default public String encryptBase64(String data) {
        return Base64.encode((byte[])this.encrypt(data));
    }

    default public byte[] encrypt(InputStream data) throws IORuntimeException {
        return this.encrypt(IoUtil.readBytes((InputStream)data));
    }

    default public String encryptHex(InputStream data) {
        return HexUtil.encodeStr((byte[])this.encrypt(data));
    }

    default public String encryptBase64(InputStream data) {
        return Base64.encode((byte[])this.encrypt(data));
    }
}

