/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric;

import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.engines.SM2Engine;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAEncoding;
import org.bouncycastle.crypto.signers.PlainDSAEncoding;
import org.bouncycastle.crypto.signers.SM2Signer;
import org.bouncycastle.crypto.signers.StandardDSAEncoding;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Hex;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.asymmetric.AbstractAsymmetricCrypto;
import org.dromara.hutool.crypto.asymmetric.KeyType;
import org.dromara.hutool.crypto.bc.ECKeyUtil;

public class SM2
extends AbstractAsymmetricCrypto<SM2> {
    private static final long serialVersionUID = 1L;
    private static final String ALGORITHM_SM2 = "SM2";
    protected SM2Engine engine;
    protected SM2Signer signer;
    private ECPrivateKeyParameters privateKeyParams;
    private ECPublicKeyParameters publicKeyParams;
    private SecureRandom random;
    private boolean removeCompressedFlag;
    private DSAEncoding encoding = StandardDSAEncoding.INSTANCE;
    private Digest digest = new SM3Digest();
    private SM2Engine.Mode mode = SM2Engine.Mode.C1C3C2;

    public SM2() {
        this(null, (byte[])null);
    }

    public SM2(String privateKeyStr, String publicKeyStr) {
        this(SecureUtil.decode(privateKeyStr), SecureUtil.decode(publicKeyStr));
    }

    public SM2(byte[] privateKey, byte[] publicKey) {
        this(ECKeyUtil.generateSm2PrivateKey(privateKey), ECKeyUtil.generateSm2PublicKey(publicKey));
    }

    public SM2(String privateKeyDValue, String publicKeyPointXHex, String publicKeyPointYHex) {
        this(SecureUtil.decode(privateKeyDValue), SecureUtil.decode(publicKeyPointXHex), SecureUtil.decode(publicKeyPointYHex));
    }

    public SM2(byte[] privateKeyDValue, byte[] publicKeyPointX, byte[] publicKeyPointY) {
        this(ECKeyUtil.generateSm2PrivateKey(privateKeyDValue), ECKeyUtil.generateSm2PublicKey(publicKeyPointX, publicKeyPointY));
    }

    public SM2(PrivateKey privateKey, PublicKey publicKey) {
        super(ALGORITHM_SM2, new KeyPair(publicKey, privateKey));
        this.privateKeyParams = ECKeyUtil.toPrivateParams(this.privateKey);
        this.publicKeyParams = ECKeyUtil.toPublicParams(this.publicKey);
        this.init();
    }

    public SM2(ECPrivateKeyParameters privateKeyParams, ECPublicKeyParameters publicKeyParams) {
        super(ALGORITHM_SM2, null);
        this.privateKeyParams = privateKeyParams;
        this.publicKeyParams = publicKeyParams;
        this.init();
    }

    public SM2 init() {
        if (null == this.privateKeyParams && null == this.publicKeyParams) {
            super.initKeys();
            this.privateKeyParams = ECKeyUtil.toPrivateParams(this.privateKey);
            this.publicKeyParams = ECKeyUtil.toPublicParams(this.publicKey);
        }
        return this;
    }

    @Override
    public SM2 initKeys() {
        return this;
    }

    public String encryptBase64(String data) {
        return this.encryptBase64(data, KeyType.PublicKey);
    }

    public String encryptBase64(InputStream in) throws IORuntimeException {
        return this.encryptBase64(in, KeyType.PublicKey);
    }

    public String encryptBase64(byte[] data) {
        return this.encryptBase64(data, KeyType.PublicKey);
    }

    public byte[] encrypt(String data) {
        return this.encrypt(data, KeyType.PublicKey);
    }

    public byte[] encrypt(InputStream in) throws IORuntimeException {
        return this.encrypt(in, KeyType.PublicKey);
    }

    public byte[] encrypt(byte[] data) throws CryptoException {
        return this.encrypt(data, KeyType.PublicKey);
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) throws CryptoException {
        if (KeyType.PublicKey != keyType) {
            throw new IllegalArgumentException("Encrypt is only support by public key");
        }
        return this.encrypt(data, (CipherParameters)new ParametersWithRandom(this.getCipherParameters(keyType), this.random));
    }

    public byte[] encrypt(byte[] data, CipherParameters pubKeyParameters) throws CryptoException {
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            engine.init(true, pubKeyParameters);
            byte[] result = engine.processBlock(data, 0, data.length);
            byte[] byArray = this.removeCompressedFlag ? SM2.removeCompressedFlag(result) : result;
            return byArray;
        }
        catch (InvalidCipherTextException e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String decryptStr(String data) {
        return this.decryptStr(data, KeyType.PrivateKey);
    }

    public String decryptStr(String data, Charset charset) {
        return this.decryptStr(data, KeyType.PrivateKey, charset);
    }

    public byte[] decrypt(InputStream in) throws IORuntimeException {
        return super.decrypt(in, KeyType.PrivateKey);
    }

    public byte[] decrypt(String data) {
        return super.decrypt(data, KeyType.PrivateKey);
    }

    public byte[] decrypt(byte[] data) throws CryptoException {
        return this.decrypt(data, KeyType.PrivateKey);
    }

    @Override
    public byte[] decrypt(byte[] data, KeyType keyType) throws CryptoException {
        if (KeyType.PrivateKey != keyType) {
            throw new IllegalArgumentException("Decrypt is only support by private key");
        }
        return this.decrypt(data, this.getCipherParameters(keyType));
    }

    public byte[] decrypt(byte[] data, CipherParameters privateKeyParameters) throws CryptoException {
        Assert.isTrue((data.length > 1 ? 1 : 0) != 0, (String)"Invalid SM2 cipher text, must be at least 1 byte long", (Object[])new Object[0]);
        data = SM2.prependCompressedFlag(data);
        this.lock.lock();
        SM2Engine engine = this.getEngine();
        try {
            engine.init(false, privateKeyParameters);
            byte[] byArray = engine.processBlock(data, 0, data.length);
            return byArray;
        }
        catch (InvalidCipherTextException e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public String signHexFromHex(String dataHex) {
        return this.signHexFromHex(dataHex, null);
    }

    public String signHexFromHex(String dataHex, String idHex) {
        return HexUtil.encodeStr((byte[])this.sign(HexUtil.decode((CharSequence)dataHex), HexUtil.decode((CharSequence)idHex)));
    }

    public String signHex(byte[] data) {
        return this.signHex(data, null);
    }

    public String signHex(byte[] data, byte[] id) {
        return HexUtil.encodeStr((byte[])this.sign(data, id));
    }

    public byte[] sign(byte[] data) {
        return this.sign(data, null);
    }

    public byte[] sign(byte[] data, byte[] id) {
        this.lock.lock();
        SM2Signer signer = this.getSigner();
        try {
            ParametersWithRandom param = new ParametersWithRandom(this.getCipherParameters(KeyType.PrivateKey), this.random);
            if (id != null) {
                param = new ParametersWithID((CipherParameters)param, id);
            }
            signer.init(true, (CipherParameters)param);
            signer.update(data, 0, data.length);
            byte[] byArray = signer.generateSignature();
            return byArray;
        }
        catch (org.bouncycastle.crypto.CryptoException e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public boolean verifyHex(String dataHex, String signHex) {
        return this.verifyHex(dataHex, signHex, null);
    }

    public boolean verify(byte[] data, byte[] sign) {
        return this.verify(data, sign, null);
    }

    public boolean verifyHex(String dataHex, String signHex, String idHex) {
        return this.verify(HexUtil.decode((CharSequence)dataHex), HexUtil.decode((CharSequence)signHex), HexUtil.decode((CharSequence)idHex));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(byte[] data, byte[] sign, byte[] id) {
        this.lock.lock();
        SM2Signer signer = this.getSigner();
        try {
            CipherParameters param = this.getCipherParameters(KeyType.PublicKey);
            if (id != null) {
                param = new ParametersWithID(param, id);
            }
            signer.init(false, param);
            signer.update(data, 0, data.length);
            boolean bl = signer.verifySignature(sign);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public SM2 setPrivateKey(PrivateKey privateKey) {
        super.setPrivateKey(privateKey);
        this.privateKeyParams = ECKeyUtil.toPrivateParams(privateKey);
        return this;
    }

    public SM2 setPrivateKeyParams(ECPrivateKeyParameters privateKeyParams) {
        this.privateKeyParams = privateKeyParams;
        return this;
    }

    @Override
    public SM2 setPublicKey(PublicKey publicKey) {
        super.setPublicKey(publicKey);
        this.publicKeyParams = ECKeyUtil.toPublicParams(publicKey);
        return this;
    }

    public SM2 setPublicKeyParams(ECPublicKeyParameters publicKeyParams) {
        this.publicKeyParams = publicKeyParams;
        return this;
    }

    public SM2 setRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public SM2 setRemoveCompressedFlag(boolean removeCompressedFlag) {
        this.removeCompressedFlag = removeCompressedFlag;
        return this;
    }

    public SM2 usePlainEncoding() {
        return this.setEncoding((DSAEncoding)PlainDSAEncoding.INSTANCE);
    }

    public SM2 setEncoding(DSAEncoding encoding) {
        this.encoding = encoding;
        this.signer = null;
        return this;
    }

    public SM2 setDigest(Digest digest) {
        this.digest = digest;
        this.engine = null;
        this.signer = null;
        return this;
    }

    public SM2 setMode(SM2Engine.Mode mode) {
        this.mode = mode;
        this.engine = null;
        return this;
    }

    public byte[] getD() {
        return BigIntegers.asUnsignedByteArray((int)32, (BigInteger)this.getDBigInteger());
    }

    public String getDHex() {
        return new String(Hex.encode((byte[])this.getD()));
    }

    public BigInteger getDBigInteger() {
        return this.privateKeyParams.getD();
    }

    public byte[] getQ(boolean isCompressed) {
        return this.publicKeyParams.getQ().getEncoded(isCompressed);
    }

    private CipherParameters getCipherParameters(KeyType keyType) {
        switch (keyType) {
            case PublicKey: {
                Assert.notNull((Object)this.publicKeyParams, (String)"PublicKey must be not null !", (Object[])new Object[0]);
                return this.publicKeyParams;
            }
            case PrivateKey: {
                Assert.notNull((Object)this.privateKeyParams, (String)"PrivateKey must be not null !", (Object[])new Object[0]);
                return this.privateKeyParams;
            }
        }
        return null;
    }

    private SM2Engine getEngine() {
        if (null == this.engine) {
            Assert.notNull((Object)this.digest, (String)"digest must be not null !", (Object[])new Object[0]);
            this.engine = new SM2Engine(this.digest, this.mode);
        }
        this.digest.reset();
        return this.engine;
    }

    private SM2Signer getSigner() {
        if (null == this.signer) {
            Assert.notNull((Object)this.digest, (String)"digest must be not null !", (Object[])new Object[0]);
            this.signer = new SM2Signer(this.encoding, this.digest);
        }
        this.digest.reset();
        return this.signer;
    }

    private static byte[] removeCompressedFlag(byte[] data) {
        if (data[0] != 4) {
            return data;
        }
        byte[] result = new byte[data.length - 1];
        System.arraycopy(data, 1, result, 0, result.length);
        return result;
    }

    private static byte[] prependCompressedFlag(byte[] data) {
        if (data[0] != 4 && data[0] != 2 && data[0] != 3) {
            data = (byte[])ArrayUtil.insert((Object)data, (int)0, (Object[])new Integer[]{4});
        }
        return data;
    }
}

