/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.digest;

import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;

public class Argon2 {
    public static final int DEFAULT_HASH_LENGTH = 32;
    private int hashLength = 32;
    private final Argon2Parameters.Builder paramsBuilder;

    public Argon2() {
        this(2);
    }

    public Argon2(int type) {
        this(new Argon2Parameters.Builder(type));
    }

    public Argon2(Argon2Parameters.Builder paramsBuilder) {
        this.paramsBuilder = paramsBuilder;
    }

    public Argon2 setHashLength(int hashLength) {
        this.hashLength = hashLength;
        return this;
    }

    public Argon2 setVersion(int version) {
        this.paramsBuilder.withVersion(version);
        return this;
    }

    public Argon2 setSalt(byte[] salt) {
        this.paramsBuilder.withSalt(salt);
        return this;
    }

    public Argon2 setSecret(byte[] secret) {
        this.paramsBuilder.withSecret(secret);
        return this;
    }

    public Argon2 setAdditional(byte[] additional) {
        this.paramsBuilder.withAdditional(additional);
        return this;
    }

    public Argon2 setIterations(int iterations) {
        this.paramsBuilder.withIterations(iterations);
        return this;
    }

    public Argon2 setMemoryAsKB(int memoryAsKB) {
        this.paramsBuilder.withMemoryAsKB(memoryAsKB);
        return this;
    }

    public Argon2 setParallelism(int parallelism) {
        this.paramsBuilder.withParallelism(parallelism);
        return this;
    }

    public byte[] digest(char[] password) {
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(this.paramsBuilder.build());
        byte[] result = new byte[this.hashLength];
        generator.generateBytes(password, result);
        return result;
    }
}

