/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.digest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.Provider;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.codec.binary.HexUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.SecureUtil;
import org.dromara.hutool.crypto.digest.DigestAlgorithm;

public class Digester
extends SimpleWrapper<MessageDigest>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected byte[] salt;
    protected int saltPosition;
    protected int digestCount;

    public Digester(DigestAlgorithm algorithm) {
        this(algorithm.getValue());
    }

    public Digester(String algorithm) {
        this(algorithm, null);
    }

    public Digester(DigestAlgorithm algorithm, Provider provider) {
        this(algorithm.getValue(), provider);
    }

    public Digester(String algorithm, Provider provider) {
        this(SecureUtil.createMessageDigest(algorithm, provider));
    }

    public Digester(MessageDigest messageDigest) {
        super((Object)messageDigest);
    }

    public Digester setSalt(byte[] salt) {
        this.salt = salt;
        return this;
    }

    public Digester setSaltPosition(int saltPosition) {
        this.saltPosition = saltPosition;
        return this;
    }

    public Digester setDigestCount(int digestCount) {
        this.digestCount = digestCount;
        return this;
    }

    public Digester reset() {
        ((MessageDigest)this.raw).reset();
        return this;
    }

    public byte[] digest(String data, Charset charset) {
        return this.digest(ByteUtil.toBytes((CharSequence)data, (Charset)charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, CharsetUtil.UTF_8);
    }

    public String digestHex(String data, Charset charset) {
        return HexUtil.encodeStr((byte[])this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, CharsetUtil.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws CryptoException {
        byte[] byArray;
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream((File)file);
            byArray = this.digest(in);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        return byArray;
    }

    public String digestHex(File file) {
        return HexUtil.encodeStr((byte[])this.digest(file));
    }

    public byte[] digest(byte[] data) {
        byte[] result;
        if (this.saltPosition <= 0) {
            result = this.doDigest(this.salt, data);
        } else if (this.saltPosition >= data.length) {
            result = this.doDigest(data, this.salt);
        } else if (ArrayUtil.isNotEmpty((byte[])this.salt)) {
            MessageDigest digest = (MessageDigest)this.raw;
            digest.update(data, 0, this.saltPosition);
            digest.update(this.salt);
            digest.update(data, this.saltPosition, data.length - this.saltPosition);
            result = digest.digest();
        } else {
            result = this.doDigest(new byte[][]{data});
        }
        return this.resetAndRepeatDigest(result);
    }

    public String digestHex(byte[] data) {
        return HexUtil.encodeStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 8192);
    }

    public String digestHex(InputStream data) {
        return HexUtil.encodeStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) throws IORuntimeException {
        byte[] result;
        if (bufferLength < 1) {
            bufferLength = 8192;
        }
        try {
            result = ArrayUtil.isEmpty((byte[])this.salt) ? this.digestWithoutSalt(data, bufferLength) : this.digestWithSalt(data, bufferLength);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this.resetAndRepeatDigest(result);
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtil.encodeStr((byte[])this.digest(data, bufferLength));
    }

    public int getDigestLength() {
        return ((MessageDigest)this.raw).getDigestLength();
    }

    private byte[] digestWithoutSalt(InputStream data, int bufferLength) throws IOException {
        int read;
        MessageDigest digest = (MessageDigest)this.raw;
        byte[] buffer = new byte[bufferLength];
        while ((read = data.read(buffer, 0, bufferLength)) > -1) {
            digest.update(buffer, 0, read);
        }
        return digest.digest();
    }

    private byte[] digestWithSalt(InputStream data, int bufferLength) throws IOException {
        int read;
        MessageDigest digest = (MessageDigest)this.raw;
        if (this.saltPosition <= 0) {
            digest.update(this.salt);
        }
        byte[] buffer = new byte[bufferLength];
        int total = 0;
        while ((read = data.read(buffer, 0, bufferLength)) > -1) {
            if (this.saltPosition > 0 && (total += read) >= this.saltPosition) {
                if (total != this.saltPosition) {
                    digest.update(buffer, 0, total - this.saltPosition);
                }
                digest.update(this.salt);
                digest.update(buffer, total - this.saltPosition, read);
                continue;
            }
            digest.update(buffer, 0, read);
        }
        if (total < this.saltPosition) {
            digest.update(this.salt);
        }
        return digest.digest();
    }

    private byte[] doDigest(byte[] ... datas) {
        MessageDigest digest = (MessageDigest)this.raw;
        for (byte[] data : datas) {
            if (null == data) continue;
            digest.update(data);
        }
        return digest.digest();
    }

    private byte[] resetAndRepeatDigest(byte[] digestData) {
        int digestCount = Math.max(1, this.digestCount);
        this.reset();
        for (int i = 0; i < digestCount - 1; ++i) {
            digestData = this.doDigest(new byte[][]{digestData});
            this.reset();
        }
        return digestData;
    }
}

