/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.digest.mac;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import org.dromara.hutool.core.codec.HexUtil;
import org.dromara.hutool.core.codec.binary.Base64;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.util.ByteUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.digest.mac.MacEngine;

public class Mac
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final MacEngine engine;

    public Mac(MacEngine engine) {
        this.engine = engine;
    }

    public MacEngine getEngine() {
        return this.engine;
    }

    public byte[] digest(String data, Charset charset) {
        return this.digest(ByteUtil.toBytes((CharSequence)data, (Charset)charset));
    }

    public byte[] digest(String data) {
        return this.digest(data, CharsetUtil.UTF_8);
    }

    public String digestBase64(String data, boolean isUrlSafe) {
        return this.digestBase64(data, CharsetUtil.UTF_8, isUrlSafe);
    }

    public String digestBase64(String data, Charset charset, boolean isUrlSafe) {
        byte[] digest = this.digest(data, charset);
        return isUrlSafe ? Base64.encodeUrlSafe((byte[])digest) : Base64.encode((byte[])digest);
    }

    public String digestHex(String data, Charset charset) {
        return HexUtil.encodeHexStr((byte[])this.digest(data, charset));
    }

    public String digestHex(String data) {
        return this.digestHex(data, CharsetUtil.UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] digest(File file) throws CryptoException {
        byte[] byArray;
        BufferedInputStream in = null;
        try {
            in = FileUtil.getInputStream((File)file);
            byArray = this.digest(in);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        return byArray;
    }

    public String digestHex(File file) {
        return HexUtil.encodeHexStr((byte[])this.digest(file));
    }

    public byte[] digest(byte[] data) {
        return this.digest(new ByteArrayInputStream(data), -1);
    }

    public String digestHex(byte[] data) {
        return HexUtil.encodeHexStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data) {
        return this.digest(data, 8192);
    }

    public String digestHex(InputStream data) {
        return HexUtil.encodeHexStr((byte[])this.digest(data));
    }

    public byte[] digest(InputStream data, int bufferLength) {
        return this.engine.digest(data, bufferLength);
    }

    public String digestHex(InputStream data, int bufferLength) {
        return HexUtil.encodeHexStr((byte[])this.digest(data, bufferLength));
    }

    public boolean verify(byte[] digest, byte[] digestToCompare) {
        return MessageDigest.isEqual(digest, digestToCompare);
    }

    public int getMacLength() {
        return this.engine.getMacLength();
    }

    public String getAlgorithm() {
        return this.engine.getAlgorithm();
    }
}

