/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.asymmetric.paillier;

import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.dromara.hutool.crypto.CryptoException;
import org.dromara.hutool.crypto.asymmetric.AbstractAsymmetricCrypto;
import org.dromara.hutool.crypto.asymmetric.KeyType;
import org.dromara.hutool.crypto.asymmetric.paillier.PaillierCipherSpiImpl;
import org.dromara.hutool.crypto.asymmetric.paillier.PaillierKeyPairGenerator;

public class PaillierCrypto
extends AbstractAsymmetricCrypto<PaillierCrypto> {
    private static final long serialVersionUID = 1L;
    private final PaillierCipherSpiImpl spi = new PaillierCipherSpiImpl();

    public PaillierCrypto() {
        this(PaillierKeyPairGenerator.of().generateKeyPair());
    }

    public PaillierCrypto(KeyPair keyPair) {
        this(keyPair.getPrivate(), keyPair.getPublic());
    }

    public PaillierCrypto(PrivateKey privateKey, PublicKey publicKey) {
        super("Paillier", privateKey, publicKey);
    }

    @Override
    public byte[] encrypt(byte[] data, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            this.initMode(1, key);
            byte[] byArray = this.doFinal(data, 0, data.length);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public byte[] decrypt(byte[] bytes, KeyType keyType) {
        Key key = this.getKeyByType(keyType);
        this.lock.lock();
        try {
            this.initMode(2, key);
            byte[] byArray = this.doFinal(bytes, 0, bytes.length);
            return byArray;
        }
        catch (Exception e) {
            throw new CryptoException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public PaillierCrypto initMode(int mode, Key key) throws InvalidKeyException {
        this.spi.engineInit(mode, key, null);
        return this;
    }

    public byte[] doFinal(byte[] input, int inputOffset, int inputLen) {
        return this.spi.engineDoFinal(input, inputOffset, inputLen);
    }
}

