/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.crypto.bc;

import java.io.IOException;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.dromara.hutool.core.io.IORuntimeException;

public class BCUtil {
    public static ECDomainParameters toDomainParams(ECParameterSpec parameterSpec) {
        return new ECDomainParameters(parameterSpec.getCurve(), parameterSpec.getG(), parameterSpec.getN(), parameterSpec.getH());
    }

    public static ECDomainParameters toDomainParams(String curveName) {
        return BCUtil.toDomainParams(ECUtil.getNamedCurveByName((String)curveName));
    }

    public static ECDomainParameters toDomainParams(X9ECParameters x9ECParameters) {
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());
    }

    public static byte[] toPkcs1(PrivateKey privateKey) {
        PrivateKeyInfo pkInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
        try {
            return pkInfo.parsePrivateKey().toASN1Primitive().getEncoded();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public static byte[] toPkcs1(PublicKey publicKey) {
        SubjectPublicKeyInfo spkInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
        try {
            return spkInfo.parsePublicKey().getEncoded();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }
}

