/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds;

import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.dromara.hutool.core.exception.CloneException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;

public class DSWrapper
extends SimpleWrapper<DataSource>
implements DataSource,
Closeable,
Cloneable {
    private final String driver;

    public static DSWrapper wrap(DataSource ds, String driver) {
        return new DSWrapper(ds, driver);
    }

    public DSWrapper(DataSource ds, String driver) {
        super((Object)ds);
        this.driver = driver;
    }

    public String getDriver() {
        return this.driver;
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return ((DataSource)this.raw).getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        ((DataSource)this.raw).setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        ((DataSource)this.raw).setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return ((DataSource)this.raw).getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return ((DataSource)this.raw).getParentLogger();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return ((DataSource)this.raw).unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return ((DataSource)this.raw).isWrapperFor(iface);
    }

    @Override
    public Connection getConnection() throws SQLException {
        return ((DataSource)this.raw).getConnection();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return ((DataSource)this.raw).getConnection(username, password);
    }

    @Override
    public void close() {
        DataSource ds = (DataSource)this.raw;
        if (ds instanceof AutoCloseable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{(AutoCloseable)((Object)ds)});
        }
    }

    public DSWrapper clone() {
        try {
            return (DSWrapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new CloneException((Throwable)e);
        }
    }
}

