/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.c3p0;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.ds.DbConfig;
import org.dromara.hutool.setting.props.Props;

public class C3p0DSFactory
implements DSFactory {
    private static final long serialVersionUID = -6090788225842047281L;

    @Override
    public String getDataSourceName() {
        return "C3P0";
    }

    @Override
    public DataSource createDataSource(DbConfig config) {
        ComboPooledDataSource ds = new ComboPooledDataSource();
        ds.setJdbcUrl(config.getUrl());
        try {
            ds.setDriverClass(config.getDriver());
        }
        catch (PropertyVetoException e) {
            throw new DbRuntimeException(e);
        }
        ds.setUser(config.getUser());
        ds.setPassword(config.getPass());
        Props.of((Properties)config.getPoolProps()).toBean((Object)ds);
        Properties connProps = config.getConnProps();
        if (MapUtil.isNotEmpty((Map)connProps)) {
            ds.setProperties(connProps);
        }
        return ds;
    }
}

