/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.ds.DbConfig;
import org.dromara.hutool.setting.props.Props;

public class HikariDSFactory
implements DSFactory {
    private static final long serialVersionUID = -8834744983614749401L;

    @Override
    public String getDataSourceName() {
        return "HikariCP";
    }

    @Override
    public DataSource createDataSource(DbConfig config) {
        String pass;
        String user;
        Props props = new Props();
        props.put((Object)"jdbcUrl", (Object)config.getUrl());
        String driver = config.getDriver();
        if (null != driver) {
            props.put((Object)"driverClassName", (Object)driver);
        }
        if (null != (user = config.getUser())) {
            props.put((Object)"username", (Object)user);
        }
        if (null != (pass = config.getPass())) {
            props.put((Object)"password", (Object)pass);
        }
        props.putAll((Map)config.getPoolProps());
        HikariConfig hikariConfig = new HikariConfig((Properties)props);
        hikariConfig.setDataSourceProperties(config.getConnProps());
        return new HikariDataSource(hikariConfig);
    }
}

