/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.lang.builder.Builder;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.dialect.DialectName;
import org.dromara.hutool.db.dialect.impl.OracleDialect;
import org.dromara.hutool.db.sql.Condition;
import org.dromara.hutool.db.sql.ConditionBuilder;
import org.dromara.hutool.db.sql.Direction;
import org.dromara.hutool.db.sql.Order;
import org.dromara.hutool.db.sql.Query;
import org.dromara.hutool.db.sql.QuoteWrapper;
import org.dromara.hutool.db.sql.SqlFormatter;

public class SqlBuilder
implements Builder<String> {
    private static final long serialVersionUID = 1L;
    private final StringBuilder sql = new StringBuilder();
    private final List<Object> paramValues = new ArrayList<Object>();
    private QuoteWrapper quoteWrapper;

    public static SqlBuilder of() {
        return new SqlBuilder();
    }

    public static SqlBuilder of(QuoteWrapper quoteWrapper) {
        return new SqlBuilder(quoteWrapper);
    }

    public static SqlBuilder of(CharSequence sql) {
        return SqlBuilder.of().append(sql);
    }

    public static void validateEntity(Entity entity) throws DbRuntimeException {
        if (null == entity) {
            throw new DbRuntimeException("Entity is null !");
        }
        if (StrUtil.isBlank((CharSequence)entity.getTableName())) {
            throw new DbRuntimeException("Entity`s table name is null !");
        }
        if (entity.isEmpty()) {
            throw new DbRuntimeException("No filed and value in this entity !");
        }
    }

    public SqlBuilder() {
    }

    public SqlBuilder(QuoteWrapper quoteWrapper) {
        this.quoteWrapper = quoteWrapper;
    }

    public SqlBuilder insert(Entity entity) {
        return this.insert(entity, DialectName.ANSI);
    }

    public SqlBuilder insert(Entity entity, DialectName dialectName) {
        return this.insert(entity, dialectName.name());
    }

    public SqlBuilder insert(Entity entity, String dialectName) {
        SqlBuilder.validateEntity(entity);
        boolean isOracle = DialectName.ORACLE.match(dialectName);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank((CharSequence)field)) {
                if (fieldsPart.length() > 0) {
                    fieldsPart.append(", ");
                    placeHolder.append(", ");
                }
                fieldsPart.append(null != this.quoteWrapper ? this.quoteWrapper.wrap((String)field) : field);
                if (isOracle && OracleDialect.isNextVal(value)) {
                    placeHolder.append(value);
                } else {
                    placeHolder.append("?");
                    this.paramValues.add(value);
                }
            }
        });
        if (DialectName.PHOENIX.match(dialectName)) {
            this.sql.append("UPSERT INTO ");
        } else {
            this.sql.append("INSERT INTO ");
        }
        String tableName = entity.getTableName();
        if (null != this.quoteWrapper) {
            tableName = this.quoteWrapper.wrap(tableName);
        }
        this.sql.append(tableName).append(" (").append((CharSequence)fieldsPart).append(") VALUES (").append((CharSequence)placeHolder).append(")");
        return this;
    }

    public SqlBuilder delete(String tableName) {
        if (StrUtil.isBlank((CharSequence)tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (null != this.quoteWrapper) {
            tableName = this.quoteWrapper.wrap(tableName);
        }
        this.sql.append("DELETE FROM ").append(tableName);
        return this;
    }

    public SqlBuilder update(Entity entity) {
        SqlBuilder.validateEntity(entity);
        String tableName = entity.getTableName();
        if (null != this.quoteWrapper) {
            tableName = this.quoteWrapper.wrap(tableName);
        }
        this.sql.append("UPDATE ").append(tableName).append(" SET ");
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank((CharSequence)field)) {
                if (!this.paramValues.isEmpty()) {
                    this.sql.append(", ");
                }
                this.sql.append(null != this.quoteWrapper ? this.quoteWrapper.wrap((String)field) : field).append(" = ? ");
                this.paramValues.add(value);
            }
        });
        return this;
    }

    public SqlBuilder select(boolean isDistinct, String ... fields) {
        return this.select(isDistinct, Arrays.asList(fields));
    }

    public SqlBuilder select(boolean isDistinct, Collection<String> fields) {
        this.sql.append("SELECT ");
        if (isDistinct) {
            this.sql.append("DISTINCT ");
        }
        if (CollUtil.isEmpty(fields)) {
            this.sql.append("*");
        } else {
            if (null != this.quoteWrapper) {
                fields = this.quoteWrapper.wrap(fields);
            }
            this.sql.append(CollUtil.join(fields, (CharSequence)","));
        }
        return this;
    }

    public SqlBuilder select(String ... fields) {
        return this.select(false, fields);
    }

    public SqlBuilder select(Collection<String> fields) {
        return this.select(false, fields);
    }

    public SqlBuilder from(String ... tableNames) {
        if (ArrayUtil.isEmpty((Object[])tableNames) || ArrayUtil.hasBlank((CharSequence[])tableNames)) {
            throw new DbRuntimeException("Table name is blank in table names !");
        }
        if (null != this.quoteWrapper) {
            tableNames = this.quoteWrapper.wrap(tableNames);
        }
        this.sql.append(" FROM ").append(ArrayUtil.join((Object[])tableNames, (CharSequence)","));
        return this;
    }

    public SqlBuilder where(Condition ... conditions) {
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            this.where(this.buildCondition(conditions));
        }
        return this;
    }

    public SqlBuilder where(String where) {
        if (StrUtil.isNotBlank((CharSequence)where)) {
            this.sql.append(" WHERE ").append(where);
        }
        return this;
    }

    public <T> SqlBuilder in(String field, T ... values) {
        this.sql.append(this.quoteWrapper.wrap(field)).append(" IN ").append("(").append(ArrayUtil.join((Object[])values, (CharSequence)",")).append(")");
        return this;
    }

    public SqlBuilder groupBy(String ... fields) {
        if (ArrayUtil.isNotEmpty((Object[])fields)) {
            if (null != this.quoteWrapper) {
                fields = this.quoteWrapper.wrap(fields);
            }
            this.sql.append(" GROUP BY ").append(ArrayUtil.join((Object[])fields, (CharSequence)","));
        }
        return this;
    }

    public SqlBuilder having(Condition ... conditions) {
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            this.having(this.buildCondition(conditions));
        }
        return this;
    }

    public SqlBuilder having(String having) {
        if (StrUtil.isNotBlank((CharSequence)having)) {
            this.sql.append(" HAVING ").append(having);
        }
        return this;
    }

    public SqlBuilder orderBy(Order ... orders) {
        if (ArrayUtil.isEmpty((Object[])orders)) {
            return this;
        }
        this.sql.append(" ORDER BY ");
        boolean isFirst = true;
        for (Order order : orders) {
            String field = order.getField();
            if (null != this.quoteWrapper) {
                field = this.quoteWrapper.wrap(field);
            }
            if (StrUtil.isBlank((CharSequence)field)) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                this.sql.append(",");
            }
            this.sql.append(field);
            Direction direction = order.getDirection();
            if (null == direction) continue;
            this.sql.append(" ").append((Object)direction);
        }
        return this;
    }

    public SqlBuilder join(String tableName, Join join) {
        if (StrUtil.isBlank((CharSequence)tableName)) {
            throw new DbRuntimeException("Table name is blank !");
        }
        if (null != join) {
            this.sql.append(" ").append((Object)join).append(" JOIN ");
            if (null != this.quoteWrapper) {
                tableName = this.quoteWrapper.wrap(tableName);
            }
            this.sql.append(tableName);
        }
        return this;
    }

    public SqlBuilder on(Condition ... conditions) {
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            this.on(this.buildCondition(conditions));
        }
        return this;
    }

    public SqlBuilder on(String on) {
        if (StrUtil.isNotBlank((CharSequence)on)) {
            this.sql.append(" ON ").append(on);
        }
        return this;
    }

    public SqlBuilder insertPreFragment(Object sqlFragment) {
        if (null != sqlFragment) {
            this.sql.insert(0, sqlFragment);
        }
        return this;
    }

    public SqlBuilder append(Object sqlFragment) {
        if (null != sqlFragment) {
            this.sql.append(sqlFragment);
        }
        return this;
    }

    public SqlBuilder addParams(Object ... params) {
        if (ArrayUtil.isNotEmpty((Object[])params)) {
            Collections.addAll(this.paramValues, params);
        }
        return this;
    }

    public SqlBuilder query(Query query) {
        return this.select(query.getFields()).from(query.getTableNames()).where(query.getWhere());
    }

    public List<Object> getParamValues() {
        return this.paramValues;
    }

    public Object[] getParamValueArray() {
        return this.paramValues.toArray(new Object[0]);
    }

    public SqlBuilder format() {
        this.sql.replace(0, this.sql.length(), SqlFormatter.format(this.sql.toString()));
        return this;
    }

    public String build() {
        return this.sql.toString();
    }

    public String toString() {
        return this.build();
    }

    private String buildCondition(Condition ... conditions) {
        if (ArrayUtil.isEmpty((Object[])conditions)) {
            return "";
        }
        if (null != this.quoteWrapper) {
            conditions = this.quoteWrapper.wrap(conditions);
        }
        return ConditionBuilder.of(conditions).build(this.paramValues);
    }

    public static enum Join {
        INNER,
        LEFT,
        RIGHT,
        FULL;

    }
}

