/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.StatementUtil;
import org.dromara.hutool.db.handler.RsHandler;
import org.dromara.hutool.db.sql.NamedSql;
import org.dromara.hutool.db.sql.SqlBuilder;

public class SqlExecutor {
    public static int execute(Connection conn, String sql, Map<String, Object> paramMap) throws DbRuntimeException {
        NamedSql namedSql = new NamedSql(sql, paramMap);
        return SqlExecutor.execute(conn, namedSql.getSql(), namedSql.getParamArray());
    }

    public static int execute(Connection conn, String sql, Object ... params) throws DbRuntimeException {
        int n;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatement(false, conn, sql, params);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
        return n;
    }

    public static boolean call(Connection conn, String sql, Object ... params) throws DbRuntimeException {
        boolean bl;
        CallableStatement call = null;
        try {
            call = StatementUtil.prepareCall(conn, sql, params);
            bl = call.execute();
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{call});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{call});
        return bl;
    }

    public static ResultSet callQuery(Connection conn, String sql, Object ... params) throws DbRuntimeException {
        try {
            return StatementUtil.prepareCall(conn, sql, params).executeQuery();
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public static Long executeForGeneratedKey(Connection conn, String sql, Map<String, Object> paramMap) throws DbRuntimeException {
        NamedSql namedSql = new NamedSql(sql, paramMap);
        return SqlExecutor.executeForGeneratedKey(conn, namedSql.getSql(), namedSql.getParamArray());
    }

    /*
     * Exception decompiling
     */
    public static Long executeForGeneratedKey(Connection conn, String sql, Object ... params) throws DbRuntimeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static int[] executeBatch(Connection conn, String sql, Iterable<Object[]> paramsBatch) throws DbRuntimeException {
        int[] nArray;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatementForBatch(conn, sql, paramsBatch);
            nArray = ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
        return nArray;
    }

    public static int[] executeBatch(Connection conn, String ... sqls) throws DbRuntimeException {
        return SqlExecutor.executeBatch(conn, (Iterable<String>)new ArrayIter((Object[])sqls));
    }

    public static int[] executeBatch(Connection conn, Iterable<String> sqls) throws DbRuntimeException {
        Object object;
        Statement statement = null;
        try {
            statement = conn.createStatement();
            for (String sql : sqls) {
                statement.addBatch(sql);
            }
            object = statement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{statement});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{statement});
        return object;
    }

    public static <T> T query(Connection conn, String sql, RsHandler<T> rsh, Map<String, Object> paramMap) throws DbRuntimeException {
        NamedSql namedSql = new NamedSql(sql, paramMap);
        return SqlExecutor.query(conn, namedSql.getSql(), rsh, namedSql.getParamArray());
    }

    public static <T> T query(Connection conn, SqlBuilder sqlBuilder, RsHandler<T> rsh) throws DbRuntimeException {
        return SqlExecutor.query(conn, sqlBuilder.build(), rsh, sqlBuilder.getParamValueArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T query(Connection conn, String sql, RsHandler<T> rsh, Object ... params) throws DbRuntimeException {
        T t;
        PreparedStatement ps = null;
        try {
            ps = StatementUtil.prepareStatement(false, conn, sql, params);
            t = SqlExecutor.executeQuery(ps, rsh);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T query(Connection conn, SerFunction<Connection, PreparedStatement> statementFunc, RsHandler<T> rsh) throws DbRuntimeException {
        T t;
        PreparedStatement ps = null;
        try {
            ps = (PreparedStatement)statementFunc.apply((Object)conn);
            t = SqlExecutor.executeQuery(ps, rsh);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
        return t;
    }

    public static int executeUpdate(PreparedStatement ps, Object ... params) throws DbRuntimeException {
        try {
            StatementUtil.fillArrayParam(ps, params);
            return ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public static boolean execute(PreparedStatement ps, Object ... params) throws DbRuntimeException {
        try {
            StatementUtil.fillArrayParam(ps, params);
            return ps.execute();
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    public static <T> T query(PreparedStatement ps, RsHandler<T> rsh, Object ... params) throws DbRuntimeException {
        try {
            StatementUtil.fillArrayParam(ps, params);
            return SqlExecutor.executeQuery(ps, rsh);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T queryAndClosePs(PreparedStatement ps, RsHandler<T> rsh, Object ... params) throws DbRuntimeException {
        T t;
        try {
            t = SqlExecutor.query(ps, rsh, params);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
        return t;
    }

    private static <T> T executeQuery(PreparedStatement ps, RsHandler<T> rsh) throws DbRuntimeException {
        T t;
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            t = rsh.handle(rs);
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{rs});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{rs});
        return t;
    }
}

