/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.sql.Condition;
import org.dromara.hutool.db.sql.SqlFormatter;

public class SqlUtil {
    public static String buildEqualsWhere(Entity entity, List<Object> paramValues) {
        if (null == entity || entity.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" WHERE ");
        boolean isNotFirst = false;
        for (Map.Entry entry : entity.entrySet()) {
            if (isNotFirst) {
                sb.append(" and ");
            } else {
                isNotFirst = true;
            }
            sb.append("`").append((String)entry.getKey()).append("`").append(" = ?");
            paramValues.add(entry.getValue());
        }
        return sb.toString();
    }

    public static Condition[] buildConditions(Entity entity) {
        if (null == entity || entity.isEmpty()) {
            return null;
        }
        Condition[] conditions = new Condition[entity.size()];
        int i = 0;
        for (Map.Entry entry : entity.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Condition) {
                conditions[i++] = (Condition)value;
                continue;
            }
            conditions[i++] = new Condition((String)entry.getKey(), value);
        }
        return conditions;
    }

    public static String buildLikeValue(String value, Condition.LikeType likeType, boolean withLikeKeyword) {
        if (null == value) {
            return null;
        }
        StringBuilder likeValue = StrUtil.builder((CharSequence)(withLikeKeyword ? "LIKE " : ""));
        switch (likeType) {
            case StartWith: {
                likeValue.append(value).append('%');
                break;
            }
            case EndWith: {
                likeValue.append('%').append(value);
                break;
            }
            case Contains: {
                likeValue.append('%').append(value).append('%');
                break;
            }
        }
        return likeValue.toString();
    }

    public static String formatSql(String sql) {
        return SqlFormatter.format(sql);
    }

    public static String rowIdToString(RowId rowId) {
        return StrUtil.str((byte[])rowId.getBytes(), (Charset)CharsetUtil.ISO_8859_1);
    }

    public static String clobToStr(Clob clob) {
        String string;
        Reader reader = null;
        try {
            reader = clob.getCharacterStream();
            string = IoUtil.read((Reader)reader);
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{reader});
        return string;
    }

    public static String blobToStr(Blob blob, Charset charset) {
        String string;
        InputStream in = null;
        try {
            in = blob.getBinaryStream();
            string = IoUtil.read((InputStream)in, (Charset)charset);
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{in});
        return string;
    }

    public static Blob createBlob(Connection conn, InputStream dataStream, boolean closeAfterUse) {
        Blob blob;
        OutputStream out = null;
        try {
            blob = conn.createBlob();
            out = blob.setBinaryStream(1L);
            IoUtil.copy((InputStream)dataStream, (OutputStream)out);
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
                if (closeAfterUse) {
                    IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{dataStream});
                }
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{out});
        if (closeAfterUse) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{dataStream});
        }
        return blob;
    }

    public static Blob createBlob(Connection conn, byte[] data) {
        Blob blob;
        try {
            blob = conn.createBlob();
            blob.setBytes(0L, data);
        }
        catch (SQLException e) {
            throw new DbRuntimeException(e);
        }
        return blob;
    }

    public static Date toSqlDate(java.util.Date date) {
        return new Date(date.getTime());
    }

    public static Timestamp toSqlTimestamp(java.util.Date date) {
        return new Timestamp(date.getTime());
    }
}

