/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.druid;

import com.alibaba.druid.pool.DruidDataSource;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.sql.DataSource;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.config.ConnectionConfig;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.setting.props.Props;

public class DruidDSFactory
implements DSFactory {
    private static final long serialVersionUID = 4680621702534433222L;

    @Override
    public String getDataSourceName() {
        return "Druid";
    }

    @Override
    public DataSource createDataSource(ConnectionConfig<?> config) {
        Properties poolProps;
        DruidDataSource ds = new DruidDataSource();
        ds.setUrl(config.getUrl());
        ds.setDriverClassName(config.getDriver());
        ds.setUsername(config.getUser());
        ds.setPassword(config.getPass());
        Properties connProps = config.getConnProps();
        if (MapUtil.isNotEmpty((Map)connProps)) {
            connProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> ds.addConnectionProperty(key.toString(), value.toString())));
        }
        if (MapUtil.isNotEmpty((Map)(poolProps = config.getPoolProps()))) {
            Props druidProps = new Props();
            poolProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> druidProps.set(StrUtil.addPrefixIfNot((CharSequence)key.toString(), (CharSequence)"druid."), value)));
            ds.configFromPropeties((Properties)druidProps);
            String connectionErrorRetryAttemptsKey = "druid.connectionErrorRetryAttempts";
            if (druidProps.containsKey((Object)"druid.connectionErrorRetryAttempts")) {
                ds.setConnectionErrorRetryAttempts(druidProps.getInt((Object)"druid.connectionErrorRetryAttempts").intValue());
            }
            String timeBetweenConnectErrorMillisKey = "druid.timeBetweenConnectErrorMillis";
            if (druidProps.containsKey((Object)"druid.timeBetweenConnectErrorMillis")) {
                ds.setTimeBetweenConnectErrorMillis((long)druidProps.getInt((Object)"druid.timeBetweenConnectErrorMillis").intValue());
            }
            String breakAfterAcquireFailureKey = "druid.breakAfterAcquireFailure";
            if (druidProps.containsKey((Object)"druid.breakAfterAcquireFailure")) {
                ds.setBreakAfterAcquireFailure(druidProps.getBool((Object)"druid.breakAfterAcquireFailure").booleanValue());
            }
            String validationQueryTimeout = "druid.validationQueryTimeout";
            if (druidProps.containsKey((Object)"druid.validationQueryTimeout")) {
                ds.setValidationQueryTimeout(druidProps.getInt((Object)"druid.validationQueryTimeout").intValue());
            }
            String queryTimeout = "druid.queryTimeout";
            if (druidProps.containsKey((Object)"druid.queryTimeout")) {
                ds.setQueryTimeout(druidProps.getInt((Object)"druid.queryTimeout").intValue());
            }
            String connectTimeout = "druid.connectTimeout";
            if (druidProps.containsKey((Object)"druid.connectTimeout")) {
                ds.setConnectTimeout(druidProps.getInt((Object)"druid.connectTimeout").intValue());
            }
            String socketTimeout = "druid.socketTimeout";
            if (druidProps.containsKey((Object)"druid.socketTimeout")) {
                ds.setSocketTimeout(druidProps.getInt((Object)"druid.socketTimeout").intValue());
            }
            String transactionQueryTimeout = "druid.transactionQueryTimeout";
            if (druidProps.containsKey((Object)"druid.transactionQueryTimeout")) {
                ds.setTransactionQueryTimeout(druidProps.getInt((Object)"druid.transactionQueryTimeout").intValue());
            }
            String loginTimeout = "druid.loginTimeout";
            if (druidProps.containsKey((Object)"druid.loginTimeout")) {
                ds.setLoginTimeout(druidProps.getInt((Object)"druid.loginTimeout").intValue());
            }
        }
        if (null == ds.getValidationQuery()) {
            ds.setTestOnBorrow(false);
            ds.setTestOnReturn(false);
            ds.setTestWhileIdle(false);
        }
        return ds;
    }
}

