/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.db.config.ConnectionConfig;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.setting.props.Props;

public class HikariDSFactory
implements DSFactory {
    private static final long serialVersionUID = -8834744983614749401L;

    @Override
    public String getDataSourceName() {
        return "HikariCP";
    }

    @Override
    public DataSource createDataSource(ConnectionConfig<?> config) {
        Properties poolProps;
        String pass;
        String user;
        Props props = new Props();
        props.put((Object)"jdbcUrl", (Object)config.getUrl());
        String driver = config.getDriver();
        if (null != driver) {
            props.put((Object)"driverClassName", (Object)driver);
        }
        if (null != (user = config.getUser())) {
            props.put((Object)"username", (Object)user);
        }
        if (null != (pass = config.getPass())) {
            props.put((Object)"password", (Object)pass);
        }
        if (MapUtil.isNotEmpty((Map)(poolProps = config.getPoolProps()))) {
            props.putAll((Map)poolProps);
        }
        HikariConfig hikariConfig = new HikariConfig((Properties)props);
        Properties connProps = config.getConnProps();
        if (MapUtil.isNotEmpty((Map)connProps)) {
            hikariConfig.setDataSourceProperties(connProps);
        }
        return new HikariDataSource(hikariConfig);
    }
}

