/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.dialect;

import java.util.Map;
import javax.sql.DataSource;
import org.dromara.hutool.core.map.concurrent.SafeConcurrentHashMap;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.dialect.Dialect;
import org.dromara.hutool.db.dialect.impl.AnsiSqlDialect;
import org.dromara.hutool.db.dialect.impl.DmDialect;
import org.dromara.hutool.db.dialect.impl.H2Dialect;
import org.dromara.hutool.db.dialect.impl.MysqlDialect;
import org.dromara.hutool.db.dialect.impl.OracleDialect;
import org.dromara.hutool.db.dialect.impl.PhoenixDialect;
import org.dromara.hutool.db.dialect.impl.PostgresqlDialect;
import org.dromara.hutool.db.dialect.impl.SqlServer2012Dialect;
import org.dromara.hutool.db.dialect.impl.Sqlite3Dialect;
import org.dromara.hutool.db.ds.DSWrapper;
import org.dromara.hutool.log.LogUtil;

public class DialectFactory {
    private static final Map<DataSource, Dialect> DIALECT_POOL = new SafeConcurrentHashMap();

    private DialectFactory() {
    }

    public static Dialect newDialect(DbConfig dbConfig) {
        Dialect dialect = DialectFactory.internalNewDialect(dbConfig);
        LogUtil.debug((String)"Use Dialect: [{}].", (Object[])new Object[]{dialect.getClass().getSimpleName()});
        return dialect;
    }

    private static Dialect internalNewDialect(DbConfig dbConfig) {
        String driverName = dbConfig.getDriver();
        if (StrUtil.isNotBlank((CharSequence)driverName)) {
            if ("com.mysql.jdbc.Driver".equalsIgnoreCase(driverName) || "com.mysql.cj.jdbc.Driver".equalsIgnoreCase(driverName)) {
                return new MysqlDialect(dbConfig);
            }
            if ("oracle.jdbc.OracleDriver".equalsIgnoreCase(driverName) || "oracle.jdbc.driver.OracleDriver".equalsIgnoreCase(driverName)) {
                return new OracleDialect(dbConfig);
            }
            if ("org.sqlite.JDBC".equalsIgnoreCase(driverName)) {
                return new Sqlite3Dialect(dbConfig);
            }
            if ("org.postgresql.Driver".equalsIgnoreCase(driverName)) {
                return new PostgresqlDialect(dbConfig);
            }
            if ("org.h2.Driver".equalsIgnoreCase(driverName)) {
                return new H2Dialect(dbConfig);
            }
            if ("com.microsoft.sqlserver.jdbc.SQLServerDriver".equalsIgnoreCase(driverName)) {
                return new SqlServer2012Dialect(dbConfig);
            }
            if ("org.apache.phoenix.jdbc.PhoenixDriver".equalsIgnoreCase(driverName)) {
                return new PhoenixDialect(dbConfig);
            }
            if ("dm.jdbc.driver.DmDriver".equalsIgnoreCase(driverName)) {
                return new DmDialect(dbConfig);
            }
        }
        return new AnsiSqlDialect(dbConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Dialect getDialect(DataSource ds) {
        Dialect dialect = DIALECT_POOL.get(ds);
        if (null == dialect) {
            DataSource dataSource = ds;
            synchronized (dataSource) {
                dialect = DIALECT_POOL.computeIfAbsent(ds, DialectFactory::newDialect);
            }
        }
        return dialect;
    }

    public static Dialect newDialect(DataSource ds) {
        return DialectFactory.newDialect(ds instanceof DSWrapper ? ((DSWrapper)ds).getDbConfig() : DbConfig.of());
    }
}

