/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.dromara.hutool.core.spi.SpiUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.ds.DSPool;
import org.dromara.hutool.db.ds.DSWrapper;
import org.dromara.hutool.log.LogUtil;

public class DSUtil {
    public static DSFactory getDefaultDsFactory() {
        return (DSFactory)SpiUtil.loadFirstAvailable(DSFactory.class);
    }

    public static DataSource getJndiDSWithLog(String jndiName) {
        try {
            return DSUtil.getJndiDS(jndiName);
        }
        catch (DbException e) {
            LogUtil.error((Throwable)e.getCause(), (String)"Find JNDI datasource error!", (Object[])new Object[0]);
            return null;
        }
    }

    public static DataSource getJndiDS(String jndiName) {
        try {
            return (DataSource)new InitialContext().lookup(jndiName);
        }
        catch (NamingException e) {
            throw new DbException(e);
        }
    }

    public static DSWrapper createDS(DbConfig dbConfig) {
        DSFactory dsFactory = dbConfig.getDsFactory();
        if (null == dsFactory) {
            dsFactory = DSUtil.getDefaultDsFactory();
        }
        return DSWrapper.wrap(dsFactory.createDataSource(dbConfig), dbConfig);
    }

    public static DSWrapper getDS() {
        return DSUtil.getDS(null);
    }

    public static DSWrapper getDS(String group) {
        return DSPool.getInstance().getDataSource(group);
    }

    public static DSFactory setGlobalDSFactory(DSFactory dsFactory) {
        DSPool.getInstance().setFactory(dsFactory);
        return dsFactory;
    }
}

