/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.jndi;

import javax.sql.DataSource;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.config.ConnectionConfig;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.ds.DSUtil;

public class JndiDSFactory
implements DSFactory {
    private static final long serialVersionUID = 1573625812927370432L;

    @Override
    public String getDataSourceName() {
        return "JNDI DataSource";
    }

    @Override
    public DataSource createDataSource(ConnectionConfig<?> config) {
        String jndiName = config.getPoolProps().getProperty("jndi");
        if (StrUtil.isEmpty((CharSequence)jndiName)) {
            throw new DbException("No setting name [jndi] for this group.");
        }
        return DSUtil.getJndiDS(jndiName);
    }
}

