/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.regex.PatternPool;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.Page;
import org.dromara.hutool.db.PageResult;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.dialect.Dialect;
import org.dromara.hutool.db.handler.NumberHandler;
import org.dromara.hutool.db.handler.PageResultHandler;
import org.dromara.hutool.db.handler.RsHandler;
import org.dromara.hutool.db.sql.Query;
import org.dromara.hutool.db.sql.QuoteWrapper;
import org.dromara.hutool.db.sql.SqlBuilder;
import org.dromara.hutool.db.sql.SqlUtil;
import org.dromara.hutool.db.sql.StatementUtil;

public class DialectRunner
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final DbConfig config;
    private final Dialect dialect;

    public DialectRunner(DbConfig config, Dialect dialect) {
        this.config = config;
        this.dialect = dialect;
    }

    public int[] insert(Connection conn, Entity ... records) throws DbException {
        int[] nArray;
        PreparedStatement ps;
        block6: {
            this.checkConn(conn);
            if (ArrayUtil.isEmpty((Object[])records)) {
                return new int[]{0};
            }
            ps = null;
            if (1 != records.length) break block6;
            ps = this.dialect.psForInsert(false, conn, records[0]);
            int[] nArray2 = new int[]{ps.executeUpdate()};
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
            return nArray2;
        }
        try {
            ps = this.dialect.psForInsertBatch(conn, records);
            nArray = ps.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new DbException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
        return nArray;
    }

    public int upsert(Connection conn, Entity record, String ... keys) throws DbException {
        PreparedStatement ps = this.dialect.psForUpsert(conn, record, keys);
        try {
            ps = this.dialect.psForUpsert(conn, record, keys);
        }
        catch (DbException dbException) {
            // empty catch block
        }
        if (null != ps) {
            int n;
            try {
                n = ps.executeUpdate();
            }
            catch (SQLException e) {
                try {
                    throw new DbException(e);
                }
                catch (Throwable throwable) {
                    IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
                    throw throwable;
                }
            }
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
            return n;
        }
        return this.insertOrUpdate(conn, record, keys);
    }

    public int insertOrUpdate(Connection conn, Entity record, String ... keys) throws DbException {
        Entity where = record.filterNew(keys);
        if (MapUtil.isNotEmpty((Map)((Object)where)) && this.count(conn, Query.of(where)) > 0L) {
            return this.update(conn, record.removeNew(keys), where);
        }
        return this.insert(conn, record)[0];
    }

    public <T> T insert(Connection conn, Entity record, RsHandler<T> generatedKeysHandler) throws DbException {
        T t;
        PreparedStatement ps;
        block6: {
            this.checkConn(conn);
            if (MapUtil.isEmpty((Map)((Object)record))) {
                throw new DbException("Empty entity provided!");
            }
            ps = null;
            ps = this.dialect.psForInsert(true, conn, record);
            ps.executeUpdate();
            if (null != generatedKeysHandler) break block6;
            T t2 = null;
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
            return t2;
        }
        try {
            t = StatementUtil.getGeneratedKeys(ps, generatedKeysHandler);
        }
        catch (SQLException e) {
            try {
                throw new DbException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
        return t;
    }

    public int del(Connection conn, Entity where) throws DbException {
        int n;
        this.checkConn(conn);
        if (MapUtil.isEmpty((Map)((Object)where))) {
            throw new DbException("Empty entity provided!");
        }
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForDelete(conn, Query.of(where));
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new DbException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
        return n;
    }

    public int update(Connection conn, Entity record, Entity where) throws DbException {
        int n;
        this.checkConn(conn);
        if (MapUtil.isEmpty((Map)((Object)record))) {
            throw new DbException("Empty entity provided!");
        }
        if (MapUtil.isEmpty((Map)((Object)where))) {
            throw new DbException("Empty where provided!");
        }
        String tableName = record.getTableName();
        if (StrUtil.isBlank((CharSequence)tableName)) {
            tableName = where.getTableName();
            record.setTableName(tableName);
        }
        Query query = new Query(SqlUtil.buildConditions(where), tableName);
        PreparedStatement ps = null;
        try {
            ps = this.dialect.psForUpdate(conn, record, query);
            n = ps.executeUpdate();
        }
        catch (SQLException e) {
            try {
                throw new DbException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{ps});
        return n;
    }

    public <T> T find(Connection conn, Query query, RsHandler<T> rsh) throws DbException {
        this.checkConn(conn);
        Assert.notNull((Object)query, (String)"[query] is null !", (Object[])new Object[0]);
        return StatementUtil.executeQuery(this.dialect.psForFind(conn, query), rsh);
    }

    public long count(Connection conn, Query query) throws DbException {
        this.checkConn(conn);
        return StatementUtil.executeQuery(this.dialect.psForCount(conn, query), NumberHandler.INSTANCE).longValue();
    }

    public long count(Connection conn, SqlBuilder sqlBuilder) throws DbException {
        this.checkConn(conn);
        String selectSql = sqlBuilder.build();
        Pattern pattern = PatternPool.get((String)"(.*?)[\\s]order[\\s]by[\\s][^\\s]+\\s(asc|desc)?", (int)2);
        Matcher matcher = pattern.matcher(selectSql);
        if (matcher.matches()) {
            selectSql = matcher.group(1);
        }
        return StatementUtil.executeQuery(this.dialect.psForCount(conn, SqlBuilder.of(selectSql).addParams(sqlBuilder.getParamValueArray())), NumberHandler.INSTANCE).longValue();
    }

    public PageResult<Entity> page(Connection conn, Query query) throws DbException {
        Page page = query.getPage();
        PageResultHandler<Entity> entityResultHandler = PageResultHandler.of(new PageResult<Entity>(page, (int)this.count(conn, query.clone().setPage(null))));
        return (PageResult)((Object)this.page(conn, query, entityResultHandler.setCaseInsensitive(this.config.isCaseInsensitive())));
    }

    public <T> T page(Connection conn, Query query, RsHandler<T> rsh) throws DbException {
        this.checkConn(conn);
        if (null == query.getPage()) {
            return this.find(conn, query, rsh);
        }
        return StatementUtil.executeQuery(this.dialect.psForPage(conn, query), rsh);
    }

    public PageResult<Entity> page(Connection conn, SqlBuilder sqlBuilder, Page page) throws DbException {
        PageResultHandler<Entity> entityResultHandler = PageResultHandler.of(new PageResult<Entity>(page, (int)this.count(conn, sqlBuilder)));
        return (PageResult)((Object)this.page(conn, sqlBuilder, page, entityResultHandler.setCaseInsensitive(this.config.isCaseInsensitive())));
    }

    public <T> T page(Connection conn, SqlBuilder sqlBuilder, Page page, RsHandler<T> rsh) throws DbException {
        this.checkConn(conn);
        return StatementUtil.executeQuery(this.dialect.psForPage(conn, sqlBuilder, page), rsh);
    }

    public void setWrapper(Character wrapperChar) {
        this.setWrapper(new QuoteWrapper(wrapperChar));
    }

    public void setWrapper(QuoteWrapper quoteWrapper) {
        this.dialect.setWrapper(quoteWrapper);
    }

    private void checkConn(Connection conn) {
        Assert.notNull((Object)conn, (String)"Connection object must be not null!", (Object[])new Object[0]);
    }
}

