/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.dialect.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.dialect.DialectName;
import org.dromara.hutool.db.dialect.impl.AnsiSqlDialect;
import org.dromara.hutool.db.sql.QuoteWrapper;
import org.dromara.hutool.db.sql.SqlBuilder;
import org.dromara.hutool.db.sql.StatementUtil;

public class PostgresqlDialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = 3889210427543389642L;

    public PostgresqlDialect(DbConfig dbConfig) {
        super(dbConfig);
        this.quoteWrapper = new QuoteWrapper(Character.valueOf('\"'));
    }

    @Override
    public String dialectName() {
        return DialectName.POSTGRESQL.name();
    }

    @Override
    public PreparedStatement psForUpsert(Connection conn, Entity entity, String ... keys) {
        Assert.notEmpty((Object[])keys, (String)"Keys must be not empty for Postgres.", (Object[])new Object[0]);
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.of(this.quoteWrapper);
        StringBuilder fieldsPart = new StringBuilder();
        StringBuilder placeHolder = new StringBuilder();
        StringBuilder updateHolder = new StringBuilder();
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank((CharSequence)field)) {
                if (fieldsPart.length() > 0) {
                    fieldsPart.append(", ");
                    placeHolder.append(", ");
                    updateHolder.append(", ");
                }
                String wrapedField = null != this.quoteWrapper ? this.quoteWrapper.wrap((String)field) : field;
                fieldsPart.append(wrapedField);
                updateHolder.append(wrapedField).append("=EXCLUDED.").append(wrapedField);
                placeHolder.append("?");
                builder.addParams(value);
            }
        });
        String tableName = entity.getTableName();
        if (null != this.quoteWrapper) {
            tableName = this.quoteWrapper.wrap(tableName);
            keys = this.quoteWrapper.wrap(keys);
        }
        builder.append("INSERT INTO ").append(tableName).append(" (").append(fieldsPart).append(") VALUES (").append(placeHolder).append(") ON CONFLICT (").append(ArrayUtil.join((Object[])keys, (CharSequence)", ")).append(") DO UPDATE SET ").append(updateHolder);
        return StatementUtil.prepareStatement(false, this.dbConfig, conn, builder.build(), builder.getParamValueArray());
    }
}

