/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.driver;

import java.util.List;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.driver.DriverNames;
import org.dromara.hutool.db.driver.matcher.Db2DriverMatcher;
import org.dromara.hutool.db.driver.matcher.DriverMatcher;
import org.dromara.hutool.db.driver.matcher.MysqlDriverMatcher;
import org.dromara.hutool.db.driver.matcher.StartsWithDriverMatcher;

public class DriverIdentifier
implements DriverNames {
    public static DriverIdentifier INSTANCE = new DriverIdentifier(null);
    private final List<DriverMatcher> matcherList;

    public DriverIdentifier(ClassLoader classLoader) {
        this.matcherList = ListUtil.of((Object[])new DriverMatcher[]{new MysqlDriverMatcher(classLoader), new StartsWithDriverMatcher("org.mariadb.jdbc.Driver", "jdbc:mariadb:"), new StartsWithDriverMatcher("oracle.jdbc.OracleDriver", "jdbc:oracle:", "JDBC:oracle:"), new StartsWithDriverMatcher("com.alibaba.jdbc.AlibabaDriver", "jdbc:alibaba:oracle:"), new StartsWithDriverMatcher("org.postgresql.Driver", "jdbc:postgresql:"), new StartsWithDriverMatcher("com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver:"), new StartsWithDriverMatcher("com.microsoft.jdbc.sqlserver.SQLServerDriver", "jdbc:microsoft:"), new StartsWithDriverMatcher("org.sqlite.JDBC", "jdbc:sqlite:"), new StartsWithDriverMatcher("org.h2.Driver", "jdbc:h2:"), new StartsWithDriverMatcher("org.apache.hadoop.hive.jdbc.HiveDriver", "jdbc:hive:"), new StartsWithDriverMatcher("org.apache.hive.jdbc.HiveDriver", "jdbc:hive2:"), new StartsWithDriverMatcher("org.apache.derby.jdbc.EmbeddedDriver", "jdbc:derby:"), new StartsWithDriverMatcher("net.sf.log4jdbc.DriverSpy", "jdbc:log4jdbc:"), new StartsWithDriverMatcher("io.tidb.bigdata.jdbc.TiDBDriver", "jdbc:tidb:"), new StartsWithDriverMatcher("com.oceanbase.jdbc.Driver", "jdbc:oceanbase:"), new StartsWithDriverMatcher("com.sybase.jdbc4.jdbc.SybDriver", "jdbc:sybase:Tds:"), new StartsWithDriverMatcher("net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:"), new StartsWithDriverMatcher("com.alibaba.druid.mock.MockDriver", "jdbc:fake:", "jdbc:mock:"), new StartsWithDriverMatcher("com.edb.Driver", "jdbc:edb:"), new StartsWithDriverMatcher("com.aliyun.odps.jdbc.OdpsDriver", "jdbc:odps:"), new StartsWithDriverMatcher("org.hsqldb.jdbc.JDBCDriver", "jdbc:hsqldb:"), new Db2DriverMatcher(), new StartsWithDriverMatcher("com.ingres.jdbc.IngresDriver", "jdbc:ingres:"), new StartsWithDriverMatcher("com.mckoi.JDBCDriver", "jdbc:mckoi:"), new StartsWithDriverMatcher("COM.cloudscape.core.JDBCDriver", "jdbc:cloudscape:"), new StartsWithDriverMatcher("com.informix.jdbc.IfxDriver", "jdbc:informix-sqli:"), new StartsWithDriverMatcher("com.timesten.jdbc.TimesTenDriver", "jdbc:timesten:"), new StartsWithDriverMatcher("com.ibm.as400.access.AS400JDBCDriver", "jdbc:as400:"), new StartsWithDriverMatcher("com.attunity.jdbc.NvDriver", "jdbc:attconnect:"), new StartsWithDriverMatcher("com.jnetdirect.jsql.JSQLDriver", "jdbc:JSQLConnect:"), new StartsWithDriverMatcher("com.newatlanta.jturbo.driver.Driver", "jdbc:JTurbo:"), new StartsWithDriverMatcher("interbase.interclient.Driver", "jdbc:interbase:"), new StartsWithDriverMatcher("com.pointbase.jdbc.jdbcUniversalDriver", "jdbc:pointbase:"), new StartsWithDriverMatcher("ca.edbc.jdbc.EdbcDriver", "jdbc:edbc:"), new StartsWithDriverMatcher("com.mimer.jdbc.Driver", "jdbc:mimer:multi1:"), new StartsWithDriverMatcher("org.apache.ignite.IgniteJdbcThinDriver", "jdbc:ignite:thin:"), new StartsWithDriverMatcher("dm.jdbc.driver.DmDriver", "jdbc:dm:"), new StartsWithDriverMatcher("com.kingbase.Driver", "jdbc:kingbase:"), new StartsWithDriverMatcher("com.kingbase8.Driver", "jdbc:kingbase8:"), new StartsWithDriverMatcher("com.gbase.jdbc.Driver", "jdbc:gbase:"), new StartsWithDriverMatcher("com.xugu.cloudjdbc.Driver", "jdbc:xugu:"), new StartsWithDriverMatcher("com.oscar.Driver", "jdbc:oscar:"), new StartsWithDriverMatcher("org.apache.phoenix.queryserver.client.Driver", "jdbc:phoenix:thin:"), new StartsWithDriverMatcher("org.apache.phoenix.jdbc.PhoenixDriver", "jdbc:phoenix:"), new StartsWithDriverMatcher("org.apache.kylin.jdbc.Driver", "jdbc:kylin:"), new StartsWithDriverMatcher("com.alibaba.xdriver.elastic.jdbc.ElasticDriver", "jdbc:elastic:"), new StartsWithDriverMatcher("com.clickhouse.jdbc.ClickHouseDriver", "jdbc:clickhouse:"), new StartsWithDriverMatcher("com.facebook.presto.jdbc.PrestoDriver", "jdbc:presto:"), new StartsWithDriverMatcher("io.trino.jdbc.TrinoDriver", "jdbc:trino:"), new StartsWithDriverMatcher("com.inspur.jdbc.KdDriver", "jdbc:inspur:"), new StartsWithDriverMatcher("com.aliyun.polardb.Driver", "jdbc:polardb"), new StartsWithDriverMatcher("com.highgo.jdbc.Driver", "jdbc:highgo:"), new StartsWithDriverMatcher("com.pivotal.jdbc.GreenplumDriver", "jdbc:pivotal:greenplum:"), new StartsWithDriverMatcher("com.huawei.gauss.jdbc.ZenithDriver", "jdbc:zenith:"), new StartsWithDriverMatcher("org.opengauss.Driver", "jdbc:opengauss:")});
    }

    public String identifyDriver(String jdbcUrl) {
        if (StrUtil.isBlank((CharSequence)jdbcUrl)) {
            return null;
        }
        return this.matcherList.stream().filter(driverMatcher -> driverMatcher.test(jdbcUrl)).findFirst().map(DriverMatcher::getClassName).orElse(null);
    }

    public DriverIdentifier addMatcher(DriverMatcher matcher) {
        if (null != matcher) {
            this.matcherList.add(matcher);
        }
        return this;
    }
}

