/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.driver;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.reflect.ClassUtil;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.driver.DriverIdentifier;
import org.dromara.hutool.db.ds.DSWrapper;

public class DriverUtil {
    public static Driver createDriver(String driverName) {
        return DriverUtil.createDriver(driverName, null);
    }

    public static Driver createDriver(String driverName, ClassLoader classLoader) {
        Class driverClass = ClassUtil.forName((String)driverName, (boolean)true, (ClassLoader)classLoader);
        return (Driver)ConstructorUtil.newInstance((Class)driverClass, (Object[])new Object[0]);
    }

    public static String identifyDriver(String nameContainsProductInfo) {
        return DriverIdentifier.INSTANCE.identifyDriver(nameContainsProductInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String identifyDriver(DataSource ds) {
        String driver;
        String driver2;
        if (ds instanceof DSWrapper && StrUtil.isNotBlank((CharSequence)(driver2 = ((DSWrapper)ds).getDriver()))) {
            return driver2;
        }
        Connection conn = null;
        try {
            try {
                conn = ds.getConnection();
            }
            catch (SQLException e) {
                throw new DbException("Get Connection error !", e);
            }
            catch (NullPointerException e) {
                throw new DbException("Unexpected NullPointException, maybe [jdbcUrl] or [url] is empty!", e);
            }
            driver = DriverUtil.identifyDriver(conn);
        }
        catch (Throwable throwable) {
            IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{conn});
            throw throwable;
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{conn});
        return driver;
    }

    public static String identifyDriver(Connection conn) throws DbException {
        String driver;
        try {
            DatabaseMetaData meta = conn.getMetaData();
            driver = DriverUtil.identifyDriver(meta.getDatabaseProductName());
            if (StrUtil.isBlank((CharSequence)driver)) {
                driver = DriverUtil.identifyDriver(meta.getDriverName());
            }
        }
        catch (SQLException e) {
            throw new DbException("Identify driver error!", e);
        }
        return driver;
    }
}

