/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.text.split.SplitUtil;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.sql.Condition;

public class QuoteWrapper
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String[] IGNORE_WRAPPER_KEYS = new String[]{"*", "(", " ", " as "};
    private Character preWrapQuote;
    private Character sufWrapQuote;

    public QuoteWrapper() {
    }

    public QuoteWrapper(Character wrapQuote) {
        this.preWrapQuote = wrapQuote;
        this.sufWrapQuote = wrapQuote;
    }

    public QuoteWrapper(Character preWrapQuote, Character sufWrapQuote) {
        this.preWrapQuote = preWrapQuote;
        this.sufWrapQuote = sufWrapQuote;
    }

    public char getPreWrapQuote() {
        return this.preWrapQuote.charValue();
    }

    public void setPreWrapQuote(Character preWrapQuote) {
        this.preWrapQuote = preWrapQuote;
    }

    public char getSufWrapQuote() {
        return this.sufWrapQuote.charValue();
    }

    public void setSufWrapQuote(Character sufWrapQuote) {
        this.sufWrapQuote = sufWrapQuote;
    }

    public String wrap(String field) {
        if (this.preWrapQuote == null || this.sufWrapQuote == null || StrUtil.isBlank((CharSequence)field)) {
            return field;
        }
        if (StrUtil.isWrap((CharSequence)field, (char)this.preWrapQuote.charValue(), (char)this.sufWrapQuote.charValue())) {
            return field;
        }
        if (StrUtil.containsAnyIgnoreCase((CharSequence)field, (CharSequence[])IGNORE_WRAPPER_KEYS)) {
            return field;
        }
        if (field.contains(".")) {
            Collection target = CollUtil.edit((Collection)SplitUtil.split((CharSequence)field, (CharSequence)".", (int)2, (boolean)true, (boolean)false), t -> StrUtil.wrap((CharSequence)t, (char)this.preWrapQuote.charValue(), (char)this.sufWrapQuote.charValue()));
            return CollUtil.join((Iterable)target, (CharSequence)".");
        }
        return StrUtil.wrap((CharSequence)field, (char)this.preWrapQuote.charValue(), (char)this.sufWrapQuote.charValue());
    }

    public String unWrap(String field) {
        if (this.preWrapQuote == null || this.sufWrapQuote == null || StrUtil.isBlank((CharSequence)field)) {
            return field;
        }
        if (!StrUtil.isWrap((CharSequence)field, (char)this.preWrapQuote.charValue(), (char)this.sufWrapQuote.charValue())) {
            return field;
        }
        if (StrUtil.containsAnyIgnoreCase((CharSequence)field, (CharSequence[])IGNORE_WRAPPER_KEYS)) {
            return field;
        }
        if (field.contains(".")) {
            Collection target = CollUtil.edit((Collection)SplitUtil.split((CharSequence)field, (CharSequence)".", (int)2, (boolean)true, (boolean)false), t -> StrUtil.unWrap((CharSequence)t, (char)this.preWrapQuote.charValue(), (char)this.sufWrapQuote.charValue()));
            return CollUtil.join((Iterable)target, (CharSequence)".");
        }
        return StrUtil.unWrap((CharSequence)field, (char)this.preWrapQuote.charValue(), (char)this.sufWrapQuote.charValue());
    }

    public String[] wrap(String ... fields) {
        if (ArrayUtil.isEmpty((Object[])fields)) {
            return fields;
        }
        String[] wrappedFields = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            wrappedFields[i] = this.wrap(fields[i]);
        }
        return wrappedFields;
    }

    public Collection<String> wrap(Collection<String> fields) {
        if (CollUtil.isEmpty(fields)) {
            return fields;
        }
        return Arrays.asList(this.wrap(fields.toArray(new String[0])));
    }

    public Entity wrap(Entity entity) {
        if (null == entity) {
            return null;
        }
        Entity wrapedEntity = new Entity();
        wrapedEntity.setTableName(this.wrap(entity.getTableName()));
        for (Map.Entry entry : entity.entrySet()) {
            wrapedEntity.set(this.wrap((String)entry.getKey()), entry.getValue());
        }
        return wrapedEntity;
    }

    public Condition[] wrap(Condition ... conditions) {
        Condition[] clonedConditions = new Condition[conditions.length];
        if (ArrayUtil.isNotEmpty((Object[])conditions)) {
            for (int i = 0; i < conditions.length; ++i) {
                Condition clonedCondition = conditions[i].clone();
                clonedCondition.setField(this.wrap(clonedCondition.getField()));
                clonedConditions[i] = clonedCondition;
            }
        }
        return clonedConditions;
    }
}

