/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.lang.Opt;
import org.dromara.hutool.core.stream.StreamUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.handler.ResultSetUtil;
import org.dromara.hutool.db.handler.RsHandler;
import org.dromara.hutool.db.sql.StatementBuilder;
import org.dromara.hutool.db.sql.StatementWrapper;
import org.dromara.hutool.db.sql.filter.SqlFilter;

public class StatementUtil {
    public static PreparedStatement prepareStatement(boolean returnGeneratedKey, DbConfig config, Connection conn, String sql, Object ... params) {
        return StatementBuilder.of().setConnection(conn).setReturnGeneratedKey(returnGeneratedKey).setSqlFilter((SqlFilter)Opt.ofNullable((Object)config).map(DbConfig::getSqlFilters).get()).setSql(sql).setParams(params).build();
    }

    public static PreparedStatement prepareStatementForBatch(DbConfig config, Connection conn, String sql, Object[] ... paramsBatch) {
        return StatementUtil.prepareStatementForBatch(config, conn, sql, (Iterable<Object[]>)new ArrayIter((Object[])paramsBatch));
    }

    public static PreparedStatement prepareStatementForBatch(DbConfig config, Connection conn, String sql, Iterable<Object[]> paramsBatch) {
        return StatementBuilder.of().setConnection(conn).setReturnGeneratedKey(false).setSqlFilter((SqlFilter)Opt.ofNullable((Object)config).map(DbConfig::getSqlFilters).get()).setSql(sql).setParamList(StreamUtil.of(paramsBatch).collect(Collectors.toList())).buildForBatch();
    }

    public static CallableStatement prepareCall(DbConfig config, Connection conn, String sql, Object ... params) throws SQLException {
        return StatementBuilder.of().setConnection(conn).setSqlFilter((SqlFilter)Opt.ofNullable((Object)config).map(DbConfig::getSqlFilters).get()).setSql(sql).setParams(params).buildForCall();
    }

    public static Long getGeneratedKeyOfLong(Statement ps) throws SQLException {
        return StatementUtil.getGeneratedKeys(ps, rs -> {
            Long generatedKey = null;
            if (rs != null && rs.next()) {
                try {
                    generatedKey = rs.getLong(1);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
            return generatedKey;
        });
    }

    public static List<Object> getGeneratedKeys(Statement ps) throws SQLException {
        return StatementUtil.getGeneratedKeys(ps, ResultSetUtil::handleRowToList);
    }

    public static <T> T getGeneratedKeys(Statement statement, RsHandler<T> rsHandler) throws SQLException {
        try (ResultSet rs = statement.getGeneratedKeys();){
            T t = rsHandler.handle(rs);
            return t;
        }
    }

    public static int getTypeOfNull(PreparedStatement ps, int paramIndex) {
        Assert.notNull((Object)ps, (String)"ps PreparedStatement must be not null in (getTypeOfNull)!", (Object[])new Object[0]);
        return StatementWrapper.of(ps).getTypeOfNull(paramIndex);
    }

    public static PreparedStatement fillArrayParam(PreparedStatement ps, Object ... params) throws SQLException {
        return StatementWrapper.of(ps).fillArrayParam(params);
    }

    public static PreparedStatement fillParams(PreparedStatement ps, Iterable<?> params) throws SQLException {
        return StatementUtil.fillParams(ps, params, null);
    }

    public static PreparedStatement fillParams(PreparedStatement ps, Iterable<?> params, Map<Integer, Integer> nullTypeCache) throws SQLException {
        return StatementWrapper.of(ps).fillParams(params, nullTypeCache);
    }

    public static void setParam(PreparedStatement ps, int paramIndex, Object param) throws SQLException {
        StatementWrapper.of(ps).setParam(paramIndex, param);
    }

    public static <T> T executeQuery(PreparedStatement ps, RsHandler<T> rsh) throws DbException {
        T t;
        ResultSet rs = null;
        try {
            rs = ps.executeQuery();
            t = rsh.handle(rs);
        }
        catch (SQLException e) {
            try {
                throw new DbException(e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{rs});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{rs});
        return t;
    }

    public static int executeUpdate(PreparedStatement ps, Object ... params) throws DbException {
        try {
            StatementUtil.fillArrayParam(ps, params);
            return ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }
}

