/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.lang.wrapper.SimpleWrapper;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.meta.Column;
import org.dromara.hutool.db.meta.ColumnIndexInfo;
import org.dromara.hutool.db.meta.IndexInfo;
import org.dromara.hutool.db.meta.MetaUtil;
import org.dromara.hutool.db.meta.Table;
import org.dromara.hutool.db.meta.TableType;

public class DatabaseMetaDataWrapper
extends SimpleWrapper<DatabaseMetaData> {
    private final String catalog;
    private final String schema;
    private final boolean isOracle;

    public static DatabaseMetaDataWrapper of(Connection conn) {
        return DatabaseMetaDataWrapper.of(MetaUtil.getMetaData(conn), MetaUtil.getCatalog(conn), MetaUtil.getSchema(conn));
    }

    public static DatabaseMetaDataWrapper of(DatabaseMetaData raw, String catalog, String schema) {
        return new DatabaseMetaDataWrapper(raw, catalog, schema);
    }

    public DatabaseMetaDataWrapper(DatabaseMetaData raw, String catalog, String schema) {
        super((Object)raw);
        this.catalog = catalog;
        this.schema = schema;
        this.isOracle = MetaUtil.isOracle(raw);
    }

    public boolean isOracle() {
        return this.isOracle;
    }

    public String getProductName() {
        try {
            return ((DatabaseMetaData)this.raw).getDatabaseProductName();
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }

    public String getDriverName() {
        try {
            return ((DatabaseMetaData)this.raw).getDriverName();
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }

    public List<String> getTableNames(String tableNamePattern, TableType ... types) {
        ArrayList<String> result = null;
        try (ResultSet rs = ((DatabaseMetaData)this.raw).getTables(this.catalog, this.schema, tableNamePattern, ConvertUtil.toStrArray((Object)types));){
            if (null != rs) {
                result = new ArrayList<String>(rs.getFetchSize());
                while (rs.next()) {
                    String table = rs.getString("TABLE_NAME");
                    if (!StrUtil.isNotBlank((CharSequence)table)) continue;
                    result.add(table);
                }
            }
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
        return CollUtil.emptyIfNull(result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRemarks(String tableName) {
        String catalog = this.catalog;
        String schema = this.schema;
        tableName = this.getPureTableName(tableName);
        try (ResultSet rs = ((DatabaseMetaData)this.raw).getTables(catalog, schema, tableName, new String[]{TableType.TABLE.value()});){
            if (null == rs) return null;
            if (!rs.next()) return null;
            String string = rs.getString("REMARKS");
            return string;
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }

    public Set<String> getPrimaryKeys(String tableName) {
        String catalog = this.catalog;
        String schema = this.schema;
        tableName = this.getPureTableName(tableName);
        LinkedHashSet<String> primaryKeys = null;
        try (ResultSet rs = ((DatabaseMetaData)this.raw).getPrimaryKeys(catalog, schema, tableName);){
            if (null != rs) {
                primaryKeys = new LinkedHashSet<String>(rs.getFetchSize(), 1.0f);
                while (rs.next()) {
                    primaryKeys.add(rs.getString("COLUMN_NAME"));
                }
            }
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
        return primaryKeys;
    }

    public Map<String, IndexInfo> getIndexInfo(String tableName) {
        String catalog = this.catalog;
        String schema = this.schema;
        LinkedHashMap<String, IndexInfo> indexInfoMap = new LinkedHashMap<String, IndexInfo>();
        try (ResultSet rs = ((DatabaseMetaData)this.raw).getIndexInfo(catalog, schema, tableName, false, false);){
            if (null != rs) {
                while (rs.next()) {
                    if (0 == rs.getShort("TYPE")) continue;
                    String indexName = rs.getString("INDEX_NAME");
                    String key = StrUtil.join((CharSequence)"&", (Object[])new Object[]{tableName, indexName});
                    IndexInfo indexInfo = (IndexInfo)indexInfoMap.get(key);
                    if (null == indexInfo) {
                        indexInfo = new IndexInfo(rs.getBoolean("NON_UNIQUE"), indexName, tableName, schema, catalog);
                        indexInfoMap.put(key, indexInfo);
                    }
                    indexInfo.getColumnIndexInfoList().add(ColumnIndexInfo.of(rs));
                }
            }
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
        return indexInfoMap;
    }

    public String[] getColumnNames(String tableName) {
        String catalog = this.catalog;
        String schema = this.schema;
        tableName = this.getPureTableName(tableName);
        ArrayList<String> columnNames = null;
        try {
            try (ResultSet rs = ((DatabaseMetaData)this.raw).getColumns(catalog, schema, tableName, null);){
                if (null != rs) {
                    columnNames = new ArrayList<String>(rs.getFetchSize());
                    while (rs.next()) {
                        columnNames.add(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            return CollUtil.isEmpty(columnNames) ? new String[]{} : columnNames.toArray(new String[0]);
        }
        catch (Exception e) {
            throw new DbException("Get columns error!", e);
        }
    }

    public void fetchColumns(Table table) {
        String catalog = this.catalog;
        String schema = this.schema;
        String tableName = this.getPureTableName((String)ObjUtil.defaultIfNull((Object)table.getPureTableName(), table::getTableName));
        try (ResultSet rs = ((DatabaseMetaData)this.raw).getColumns(catalog, schema, tableName, null);){
            if (null != rs) {
                while (rs.next()) {
                    table.addColumn(Column.of(table, rs));
                }
            }
        }
        catch (SQLException e) {
            throw new DbException(e);
        }
    }

    public String getPureTableName(String tableName) {
        int wrapChar = 34;
        if (StrUtil.isWrap((CharSequence)tableName, (char)'\"') && this.isOracle) {
            tableName = StrUtil.unWrap((CharSequence)tableName, (char)'\"');
        }
        return tableName;
    }
}

