/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db;

import java.nio.charset.Charset;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.CollUtil;
import org.dromara.hutool.core.collection.iter.ArrayIter;
import org.dromara.hutool.core.collection.set.SetUtil;
import org.dromara.hutool.core.func.SerSupplier;
import org.dromara.hutool.core.map.Dict;
import org.dromara.hutool.core.reflect.method.MethodUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.core.util.CharsetUtil;
import org.dromara.hutool.core.util.ObjUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.sql.Condition;
import org.dromara.hutool.db.sql.SqlUtil;

public class Entity
extends Dict {
    private static final long serialVersionUID = -1951012511464327448L;
    private Meta meta;

    public static Entity of() {
        return new Entity();
    }

    public static Entity of(String tableName) {
        return new Entity(tableName);
    }

    public static <T> Entity ofWithUnderlineCase(T bean) {
        return Entity.of(null).parseBean((Object)bean, true, true);
    }

    public static <T> Entity of(T bean) {
        return Entity.of(null).parseBean((Object)bean);
    }

    public static <T> Entity of(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return Entity.of(null).parseBean((Object)bean, isToUnderlineCase, ignoreNullValue);
    }

    public Entity() {
    }

    public Entity(String tableName) {
        this(tableName, false);
    }

    public Entity(String tableName, boolean caseInsensitive) {
        this(new Meta(tableName, null), caseInsensitive);
    }

    public Entity(Meta meta, boolean caseInsensitive) {
        super(caseInsensitive);
        this.meta = meta;
    }

    public Meta getMeta() {
        return this.meta;
    }

    public Entity setMeta(Meta meta) {
        this.meta = meta;
        return this;
    }

    public String getTableName() {
        return null == this.meta ? null : this.meta.getTableName();
    }

    public Entity setTableName(String tableName) {
        if (null == this.meta) {
            this.meta = new Meta(tableName, null);
        } else {
            this.meta.setTableName(tableName);
        }
        return this;
    }

    public Set<String> getFieldNames() {
        return null == this.meta ? null : this.meta.getFieldNames();
    }

    public Entity setFieldNames(Iterable<String> fieldNames) {
        if (CollUtil.isNotEmpty(fieldNames)) {
            HashSet fieldNameSet = SetUtil.of((boolean)true, fieldNames);
            if (null == this.meta) {
                this.meta = new Meta(null, fieldNameSet);
            } else {
                this.meta.setFieldNames(fieldNameSet);
            }
        }
        return this;
    }

    public Entity setFieldNames(String ... fieldNames) {
        if (ArrayUtil.isNotEmpty((Object[])fieldNames)) {
            this.setFieldNames((Iterable<String>)new ArrayIter((Object[])fieldNames));
        }
        return this;
    }

    public Entity setFields(SerSupplier<?> ... fields) {
        return (Entity)super.setFields(fields);
    }

    public Entity addFieldNames(String ... fieldNames) {
        if (ArrayUtil.isNotEmpty((Object[])fieldNames)) {
            if (null == this.meta || CollUtil.isEmpty((Collection)this.meta.fieldNames)) {
                return this.setFieldNames(fieldNames);
            }
            Collections.addAll(this.meta.fieldNames, fieldNames);
        }
        return this;
    }

    public <T> Entity parseBean(T bean) {
        if (null == this.meta || StrUtil.isBlank((CharSequence)this.meta.tableName)) {
            this.setTableName(StrUtil.lowerFirst((CharSequence)bean.getClass().getSimpleName()));
        }
        return (Entity)super.parseBean(bean);
    }

    public <T> Entity parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        if (null == this.meta || StrUtil.isBlank((CharSequence)this.meta.tableName)) {
            String simpleName = bean.getClass().getSimpleName();
            this.setTableName(isToUnderlineCase ? StrUtil.toUnderlineCase((CharSequence)simpleName) : StrUtil.lowerFirst((CharSequence)simpleName));
        }
        return (Entity)super.parseBean(bean, isToUnderlineCase, ignoreNullValue);
    }

    public Entity filterNew(String ... keys) {
        Entity result = new Entity(this.meta, this.caseInsensitive);
        for (String key : keys) {
            if (!this.containsKey(key)) continue;
            result.put(key, this.get(key));
        }
        return result;
    }

    public Entity removeNew(String ... keys) {
        return (Entity)super.removeNew(keys);
    }

    public Entity addCondition(Condition condition) {
        return this.set(condition.getField(), condition);
    }

    public Entity set(String field, Object value) {
        return (Entity)super.set(field, value);
    }

    public Entity setIgnoreNull(String field, Object value) {
        return (Entity)super.setIgnoreNull(field, value);
    }

    public Clob getClob(String field) {
        return (Clob)this.get(field);
    }

    public Blob getBlob(String field) {
        return (Blob)this.get(field);
    }

    public Time getSqlTime(String field, Time defaultValue) {
        Object obj = this.get(field);
        Time result = null;
        if (null != obj) {
            try {
                result = (Time)obj;
            }
            catch (Exception e) {
                result = (Time)MethodUtil.invoke((Object)obj, (String)"timeValue", (Object[])new Object[0]);
            }
        }
        return (Time)ObjUtil.defaultIfNull(result, (Object)defaultValue);
    }

    public Date getDate(String field, Date defaultValue) {
        Object obj = this.get(field);
        Date result = null;
        if (null != obj) {
            try {
                result = (Date)obj;
            }
            catch (Exception e) {
                result = (Date)MethodUtil.invoke((Object)obj, (String)"dateValue", (Object[])new Object[0]);
            }
        }
        return (Date)ObjUtil.defaultIfNull(result, (Object)defaultValue);
    }

    public Timestamp getSqlTimestamp(String field, Timestamp defaultValue) {
        Object obj = this.get(field);
        Timestamp result = null;
        if (null != obj) {
            try {
                result = (Timestamp)obj;
            }
            catch (Exception e) {
                result = (Timestamp)MethodUtil.invoke((Object)obj, (String)"timestampValue", (Object[])new Object[0]);
            }
        }
        return (Timestamp)ObjUtil.defaultIfNull(result, (Object)defaultValue);
    }

    public String getStr(String field, String defaultValue) {
        return this.getStr(field, CharsetUtil.UTF_8, defaultValue);
    }

    public String getStr(String field, Charset charset, String defaultValue) {
        Object obj = this.getObj(field, defaultValue);
        if (obj instanceof Clob) {
            return SqlUtil.clobToStr((Clob)obj);
        }
        if (obj instanceof Blob) {
            return SqlUtil.blobToStr((Blob)obj, charset);
        }
        if (obj instanceof RowId) {
            RowId rowId = (RowId)obj;
            return StrUtil.str((byte[])rowId.getBytes(), (Charset)charset);
        }
        return super.getStr((Object)field, defaultValue);
    }

    public RowId getRowId() {
        return this.getRowId("ROWID");
    }

    public RowId getRowId(String field) {
        Object obj = this.get(field);
        if (null == obj) {
            return null;
        }
        if (obj instanceof RowId) {
            return (RowId)obj;
        }
        throw new DbException("Value of field [{}] is not a rowid!", field);
    }

    public Entity clone() {
        return (Entity)super.clone();
    }

    public String toString() {
        return "Entity {meta=" + this.meta + ", fields=" + super.toString() + "}";
    }

    public static class Meta {
        private String tableName;
        private Set<String> fieldNames;

        public Meta(String tableName, Set<String> fieldNames) {
            this.tableName = tableName;
            this.fieldNames = fieldNames;
        }

        public String getTableName() {
            return this.tableName;
        }

        public Meta setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Set<String> getFieldNames() {
            return this.fieldNames;
        }

        public Meta setFieldNames(Set<String> fieldNames) {
            this.fieldNames = fieldNames;
            return this;
        }
    }
}

