/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.config;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.io.resource.NoResourceException;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.config.ConfigParser;
import org.dromara.hutool.db.config.DSKeys;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.driver.DriverUtil;
import org.dromara.hutool.db.sql.SqlLog;
import org.dromara.hutool.db.sql.filter.SqlLogFilter;
import org.dromara.hutool.log.level.Level;
import org.dromara.hutool.setting.Setting;

public class SettingConfigParser
implements ConfigParser {
    private static final String CONNECTION_PREFIX = "connection.";
    private static final String DEFAULT_DB_SETTING_PATH = "config/db.setting";
    private static final String DEFAULT_DB_SETTING_PATH2 = "db.setting";
    private final Setting setting;

    public static SettingConfigParser of() {
        return SettingConfigParser.of(null);
    }

    public static SettingConfigParser of(Setting setting) {
        return new SettingConfigParser(setting);
    }

    public SettingConfigParser(Setting setting) {
        this.setting = null != setting ? setting : SettingConfigParser.createDefaultSetting();
    }

    @Override
    public DbConfig parse(String group) {
        Setting setting = this.setting;
        Setting subSetting = setting.getSetting(StrUtil.toStringOrEmpty((Object)group));
        if (MapUtil.isEmpty((Map)subSetting)) {
            throw new DbException("No config for group: [{}]", group);
        }
        subSetting.putIfAbsent((Object)"showSql", (Object)setting.get((Object)"showSql"));
        subSetting.putIfAbsent((Object)"formatSql", (Object)setting.get((Object)"formatSql"));
        subSetting.putIfAbsent((Object)"showParams", (Object)setting.get((Object)"showParams"));
        subSetting.putIfAbsent((Object)"sqlLevel", (Object)setting.get((Object)"sqlLevel"));
        return SettingConfigParser.toDbConfig(subSetting);
    }

    private static Setting createDefaultSetting() {
        Setting setting;
        try {
            setting = new Setting(DEFAULT_DB_SETTING_PATH, true);
        }
        catch (NoResourceException e) {
            try {
                setting = new Setting(DEFAULT_DB_SETTING_PATH2, true);
            }
            catch (NoResourceException e2) {
                throw new NoResourceException("Default db setting [{}] or [{}] in classpath not found !", new Object[]{DEFAULT_DB_SETTING_PATH, DEFAULT_DB_SETTING_PATH2});
            }
        }
        return setting;
    }

    private static DbConfig toDbConfig(Setting setting) {
        String caseInsensitive;
        String url = setting.getAndRemove(DSKeys.KEY_ALIAS_URL);
        if (StrUtil.isBlank((CharSequence)url)) {
            throw new DbException("No JDBC URL!");
        }
        String driver = setting.getAndRemove(DSKeys.KEY_ALIAS_DRIVER);
        if (StrUtil.isBlank((CharSequence)driver)) {
            driver = DriverUtil.identifyDriver(url);
        }
        DbConfig dbConfig = (DbConfig)((DbConfig)((DbConfig)((DbConfig)DbConfig.of().setUrl(url)).setDriver(driver)).setUser(setting.getAndRemove(DSKeys.KEY_ALIAS_USER))).setPass(setting.getAndRemove(DSKeys.KEY_ALIAS_PASSWORD));
        SqlLogFilter sqlLogFilter = SettingConfigParser.getSqlLogFilter(setting);
        if (null != sqlLogFilter) {
            dbConfig.addSqlFilter(sqlLogFilter);
        }
        if (StrUtil.isNotBlank((CharSequence)(caseInsensitive = setting.getAndRemove(new String[]{"caseInsensitive"})))) {
            dbConfig.setCaseInsensitive(ConvertUtil.toBoolean((Object)caseInsensitive));
        }
        for (String key : DSKeys.KEY_CONN_PROPS) {
            String connValue = setting.getAndRemove(new String[]{key});
            if (!StrUtil.isNotBlank((CharSequence)connValue)) continue;
            dbConfig.addConnProps(key, connValue);
        }
        Set keys = setting.keySet();
        for (String key : keys) {
            if (!key.startsWith(CONNECTION_PREFIX)) continue;
            dbConfig.addConnProps(StrUtil.subSuf((CharSequence)key, (int)CONNECTION_PREFIX.length()), setting.remove((Object)key));
        }
        dbConfig.setPoolProps((Properties)setting.toProps());
        return dbConfig;
    }

    private static SqlLogFilter getSqlLogFilter(Setting setting) {
        boolean isShowSql = ConvertUtil.toBoolean((Object)setting.remove((Object)"showSql"), (Boolean)false);
        if (!isShowSql) {
            return null;
        }
        boolean isFormatSql = ConvertUtil.toBoolean((Object)setting.remove((Object)"formatSql"), (Boolean)false);
        boolean isShowParams = ConvertUtil.toBoolean((Object)setting.remove((Object)"showParams"), (Boolean)false);
        String sqlLevelStr = setting.remove((Object)"sqlLevel");
        if (null != sqlLevelStr) {
            sqlLevelStr = sqlLevelStr.toUpperCase();
        }
        Level level = (Level)ConvertUtil.toEnum(Level.class, (Object)sqlLevelStr, (Enum)Level.DEBUG);
        SqlLog sqlLog = new SqlLog();
        sqlLog.init(isShowSql, isFormatSql, isShowParams, level);
        return new SqlLogFilter(sqlLog);
    }
}

