/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.pooled;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.pool.ObjectFactory;
import org.dromara.hutool.core.pool.ObjectPool;
import org.dromara.hutool.core.pool.partition.PartitionObjectPool;
import org.dromara.hutool.core.pool.partition.PartitionPoolConfig;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.config.ConnectionConfig;
import org.dromara.hutool.db.driver.DriverUtil;
import org.dromara.hutool.db.ds.pooled.PooledConnection;
import org.dromara.hutool.db.ds.simple.AbstractDataSource;
import org.dromara.hutool.log.LogUtil;
import org.dromara.hutool.setting.props.Props;

public class PooledDataSource
extends AbstractDataSource {
    private static final String KEY_MAX_WAIT = "maxWait";
    private static final String KEY_INITIAL_SIZE = "initialSize";
    private static final String KEY_MAX_ACTIVE = "maxActive";
    protected Driver driver;
    private final int maxWait;
    private final ObjectPool<PooledConnection> connPool;

    public PooledDataSource(ConnectionConfig<?> config) {
        String driverName = config.getDriver();
        if (StrUtil.isNotBlank((CharSequence)driverName)) {
            this.driver = DriverUtil.createDriver(driverName);
        }
        Props poolProps = Props.of((Properties)config.getPoolProps());
        this.maxWait = poolProps.getInt((Object)KEY_MAX_WAIT, Integer.valueOf(6000));
        PartitionPoolConfig poolConfig = (PartitionPoolConfig)PartitionPoolConfig.of().setPartitionSize(1).setMaxWait((long)this.maxWait).setMinSize(poolProps.getInt((Object)KEY_INITIAL_SIZE, Integer.valueOf(0)).intValue()).setMaxSize(poolProps.getInt((Object)KEY_MAX_ACTIVE, Integer.valueOf(8)).intValue());
        this.connPool = new PartitionObjectPool(poolConfig, this.createConnFactory(config));
    }

    public PooledDataSource setDriver(Driver driver) {
        this.driver = driver;
        return this;
    }

    @Override
    public PooledConnection getConnection() throws SQLException {
        return (PooledConnection)this.connPool.borrowObject();
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        throw new SQLException("Pooled DataSource is not allow to get special Connection!");
    }

    @Override
    public void close() {
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.connPool});
    }

    public void returnObject(PooledConnection conn) {
        this.connPool.returnObject((Object)conn);
    }

    private ObjectFactory<PooledConnection> createConnFactory(final ConnectionConfig<?> config) {
        return new ObjectFactory<PooledConnection>(){

            public PooledConnection create() {
                return new PooledConnection(config, PooledDataSource.this);
            }

            public boolean validate(PooledConnection connection) {
                try {
                    return null != connection && connection.isValid(PooledDataSource.this.maxWait);
                }
                catch (SQLException e) {
                    LogUtil.error((Throwable)e);
                    return false;
                }
            }

            public void destroy(PooledConnection connection) {
                if (null != connection) {
                    connection.destroy();
                }
            }
        };
    }
}

