/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.handler;

import java.lang.reflect.Type;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import org.dromara.hutool.core.convert.ConvertUtil;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.handler.row.ArrayRowHandler;
import org.dromara.hutool.db.handler.row.BeanRowHandler;
import org.dromara.hutool.db.handler.row.EntityRowHandler;
import org.dromara.hutool.db.handler.row.ListRowHandler;

public class ResultSetUtil {
    public static <T> T toBean(ResultSetMetaData meta, ResultSet rs, Class<T> beanClass) throws SQLException {
        Assert.notNull(beanClass, (String)"Bean Class must be not null !", (Object[])new Object[0]);
        if (beanClass.isArray()) {
            return (T)new ArrayRowHandler(meta, beanClass.getComponentType()).handle(rs);
        }
        if (Iterable.class.isAssignableFrom(beanClass)) {
            Object[] objRow = ResultSetUtil.toBean(meta, rs, Object[].class);
            return (T)ConvertUtil.convert(beanClass, (Object)objRow);
        }
        if (beanClass.isAssignableFrom(Entity.class)) {
            return (T)((Object)new EntityRowHandler(meta, false, true).handle(rs));
        }
        if (String.class == beanClass) {
            Object[] objRow = ResultSetUtil.toBean(meta, rs, Object[].class);
            return (T)StrUtil.join((CharSequence)", ", (Object[])objRow);
        }
        return new BeanRowHandler<T>(meta, beanClass, true).handle(rs);
    }

    public static List<Object> handleRowToList(ResultSet rs) throws SQLException {
        return new ListRowHandler<Object>(rs.getMetaData(), Object.class).handle(rs);
    }

    public static <T extends Collection<Entity>> T toEntityList(ResultSet rs, T collection) throws SQLException {
        return ResultSetUtil.toEntityList(rs, collection, false);
    }

    public static <T extends Collection<Entity>> T toEntityList(ResultSet rs, T collection, boolean caseInsensitive) throws SQLException {
        EntityRowHandler rowHandler = new EntityRowHandler(rs.getMetaData(), caseInsensitive, true);
        while (rs.next()) {
            collection.add(rowHandler.handle(rs));
        }
        return collection;
    }

    public static <E, T extends Collection<E>> T toBeanList(ResultSet rs, T collection, Class<E> elementBeanType) throws SQLException {
        ResultSetMetaData meta = rs.getMetaData();
        while (rs.next()) {
            collection.add(ResultSetUtil.toBean(meta, rs, elementBeanType));
        }
        return collection;
    }

    public static Long toLong(ResultSet rs) throws SQLException {
        Long generatedKey = null;
        if (rs != null && rs.next()) {
            try {
                generatedKey = rs.getLong(1);
            }
            catch (DbException dbException) {
                // empty catch block
            }
        }
        return generatedKey;
    }

    public static Object getColumnValue(ResultSet rs, int columnIndex, int type, Type targetColumnType) throws SQLException {
        Object rawValue = null;
        switch (type) {
            case 93: {
                try {
                    rawValue = rs.getTimestamp(columnIndex);
                }
                catch (SQLException sQLException) {}
                break;
            }
            case 92: {
                rawValue = rs.getTime(columnIndex);
                break;
            }
            default: {
                rawValue = rs.getObject(columnIndex);
            }
        }
        if (null == targetColumnType || Object.class == targetColumnType) {
            return rawValue;
        }
        return ConvertUtil.convert((Type)targetColumnType, (Object)rawValue);
    }
}

