/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db;

import java.util.Map;
import org.dromara.hutool.core.func.SerSupplier;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.db.Db;
import org.dromara.hutool.db.Entity;

public class ActiveEntity
extends Entity {
    private static final long serialVersionUID = 6112321379601134750L;
    private final Db db;

    public static ActiveEntity of() {
        return new ActiveEntity();
    }

    public static ActiveEntity of(String tableName) {
        return new ActiveEntity(tableName);
    }

    public static <T> ActiveEntity parse(T bean) {
        return ActiveEntity.of(null).parseBean((Object)bean);
    }

    public static <T> ActiveEntity parse(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return ActiveEntity.of(null).parseBean((Object)bean, isToUnderlineCase, ignoreNullValue);
    }

    public static <T> ActiveEntity parseWithUnderlineCase(T bean) {
        return ActiveEntity.of(null).parseBean((Object)bean, true, true);
    }

    public ActiveEntity() {
        this(Db.of(), (String)null);
    }

    public ActiveEntity(String tableName) {
        this(Db.of(), tableName);
    }

    public ActiveEntity(Entity entity) {
        this(Db.of(), entity);
    }

    public ActiveEntity(Db db, String tableName) {
        super(tableName);
        this.db = db;
    }

    public ActiveEntity(Db db, Entity entity) {
        super(entity.getTableName());
        this.putAll((Map)((Object)entity));
        this.db = db;
    }

    @Override
    public ActiveEntity setTableName(String tableName) {
        return (ActiveEntity)super.setTableName(tableName);
    }

    @Override
    public ActiveEntity setFieldNames(Iterable<String> fieldNames) {
        return (ActiveEntity)super.setFieldNames(fieldNames);
    }

    @Override
    public ActiveEntity setFieldNames(String ... fieldNames) {
        return (ActiveEntity)super.setFieldNames(fieldNames);
    }

    @Override
    public ActiveEntity setFields(SerSupplier<?> ... fields) {
        return (ActiveEntity)super.setFields((SerSupplier[])fields);
    }

    @Override
    public ActiveEntity addFieldNames(String ... fieldNames) {
        return (ActiveEntity)super.addFieldNames(fieldNames);
    }

    @Override
    public <T> ActiveEntity parseBean(T bean) {
        return (ActiveEntity)super.parseBean((Object)bean);
    }

    @Override
    public <T> ActiveEntity parseBean(T bean, boolean isToUnderlineCase, boolean ignoreNullValue) {
        return (ActiveEntity)super.parseBean((Object)bean, isToUnderlineCase, ignoreNullValue);
    }

    @Override
    public ActiveEntity set(String field, Object value) {
        return (ActiveEntity)super.set(field, value);
    }

    @Override
    public ActiveEntity setIgnoreNull(String field, Object value) {
        return (ActiveEntity)super.setIgnoreNull(field, value);
    }

    @Override
    public ActiveEntity clone() {
        return (ActiveEntity)super.clone();
    }

    public ActiveEntity add() {
        this.db.insert(this);
        return this;
    }

    public ActiveEntity load() {
        Entity result = this.db.get(this);
        if (MapUtil.isNotEmpty((Map)((Object)result))) {
            this.putAll((Map)((Object)result));
        }
        return this;
    }

    public ActiveEntity del() {
        this.db.del(this);
        return this;
    }

    public ActiveEntity update(String primaryKey) {
        this.db.update(this, Entity.of().set(primaryKey, this.get(primaryKey)));
        return this;
    }
}

