/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.handler.row;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.db.handler.ResultSetUtil;
import org.dromara.hutool.db.handler.row.AbsRowHandler;

public class ArrayRowHandler<E>
extends AbsRowHandler<E[]> {
    private final Class<E> componentType;

    public ArrayRowHandler(ResultSetMetaData meta, Class<E> componentType) throws SQLException {
        super(meta);
        this.componentType = componentType;
    }

    @Override
    public E[] handle(ResultSet rs) throws SQLException {
        Object[] result = ArrayUtil.newArray(this.componentType, (int)this.columnCount);
        int i = 0;
        int j = 1;
        while (i < this.columnCount) {
            result[i] = ResultSetUtil.getColumnValue(rs, j, this.meta.getColumnType(j), this.componentType);
            ++i;
            ++j;
        }
        return result;
    }
}

