/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.handler.row;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Map;
import org.dromara.hutool.core.bean.BeanUtil;
import org.dromara.hutool.core.bean.PropDesc;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.reflect.Invoker;
import org.dromara.hutool.core.reflect.method.MethodInvoker;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.handler.ResultSetUtil;
import org.dromara.hutool.db.handler.row.AbsRowHandler;

public class BeanRowHandler<T>
extends AbsRowHandler<T> {
    private final Class<T> beanType;
    private final boolean caseInsensitive;

    public BeanRowHandler(ResultSetMetaData meta, Class<T> beanType, boolean caseInsensitive) throws SQLException {
        super(meta);
        this.beanType = beanType;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public T handle(ResultSet rs) throws SQLException {
        Object bean = ConstructorUtil.newInstanceIfPossible(this.beanType);
        Map propMap = BeanUtil.getBeanDesc(this.beanType).getPropMap(this.caseInsensitive);
        for (int i = 1; i <= this.columnCount; ++i) {
            Invoker setter;
            String columnLabel = this.meta.getColumnLabel(i);
            PropDesc pd = (PropDesc)propMap.get(columnLabel);
            if (null == pd) {
                pd = (PropDesc)propMap.get(StrUtil.toCamelCase((CharSequence)columnLabel));
            }
            Invoker invoker = setter = null == pd ? null : pd.getSetter();
            if (null == setter) continue;
            Object value = ResultSetUtil.getColumnValue(rs, i, this.meta.getColumnType(i), setter.getType());
            if (setter instanceof MethodInvoker) {
                MethodInvoker.of((Method)((MethodInvoker)setter).getMethod()).setCheckArgs(true).invoke(bean, new Object[]{value});
                continue;
            }
            setter.invoke(bean, new Object[]{value});
        }
        return (T)bean;
    }
}

