/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.dialect.impl;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Collections;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.config.DbConfig;
import org.dromara.hutool.db.dialect.DialectName;
import org.dromara.hutool.db.dialect.impl.AnsiSqlDialect;
import org.dromara.hutool.db.sql.QuoteWrapper;
import org.dromara.hutool.db.sql.SqlBuilder;
import org.dromara.hutool.db.sql.StatementUtil;

public class HanaDialect
extends AnsiSqlDialect {
    private static final long serialVersionUID = 1L;

    public HanaDialect(DbConfig config) {
        super(config);
        this.quoteWrapper = new QuoteWrapper(Character.valueOf('\"'));
    }

    @Override
    public String dialectName() {
        return DialectName.HANA.name();
    }

    @Override
    public PreparedStatement psForUpsert(Connection conn, Entity entity, String ... keys) throws DbException {
        SqlBuilder.validateEntity(entity);
        SqlBuilder builder = SqlBuilder.of(this.quoteWrapper);
        ArrayList columns = new ArrayList();
        entity.forEach((field, value) -> {
            if (StrUtil.isNotBlank((CharSequence)field)) {
                columns.add(this.quoteWrapper != null ? this.quoteWrapper.wrap((String)field) : field);
                builder.addParams(value);
            }
        });
        String tableName = entity.getTableName();
        if (this.quoteWrapper != null) {
            tableName = this.quoteWrapper.wrap(tableName);
        }
        builder.append("UPSERT ").append(tableName).append(" (");
        builder.append(String.join((CharSequence)", ", columns));
        builder.append(") VALUES (");
        builder.append(String.join((CharSequence)", ", Collections.nCopies(columns.size(), "?")));
        builder.append(") WITH PRIMARY KEY");
        return StatementUtil.prepareStatement(false, this.dbConfig, conn, builder.build(), builder.getParamValueArray());
    }
}

