/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.handler.row;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.handler.ResultSetUtil;
import org.dromara.hutool.db.handler.row.AbsRowHandler;

public class EntityRowHandler
extends AbsRowHandler<Entity> {
    private final boolean caseInsensitive;
    private final boolean withMetaInfo;

    public EntityRowHandler(ResultSetMetaData meta, boolean caseInsensitive, boolean withMetaInfo) throws SQLException {
        super(meta);
        this.caseInsensitive = caseInsensitive;
        this.withMetaInfo = withMetaInfo;
    }

    @Override
    public Entity handle(ResultSet rs) throws SQLException {
        Entity entity = new Entity((Entity.Meta)null, this.caseInsensitive);
        return this.fillEntity(entity, rs);
    }

    private <T extends Entity> T fillEntity(T row, ResultSet rs) throws SQLException {
        for (int i = 1; i <= this.columnCount; ++i) {
            int type = this.meta.getColumnType(i);
            String columnLabel = this.meta.getColumnLabel(i);
            if ("rownum_".equalsIgnoreCase(columnLabel)) continue;
            row.put(columnLabel, ResultSetUtil.getColumnValue(rs, i, type, null));
        }
        if (this.withMetaInfo) {
            try {
                row.setTableName(this.meta.getTableName(1));
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            row.setFieldNames(row.keySet());
        }
        return row;
    }
}

