/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.dromara.hutool.core.lang.builder.Builder;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.sql.Condition;
import org.dromara.hutool.db.sql.Query;

public class QueryBuilder
implements Builder<Query> {
    private static final long serialVersionUID = 1L;
    private final List<String> fields = new ArrayList<String>();
    private final List<String> tableNames = new ArrayList<String>();
    private final List<Condition> wheres = new ArrayList<Condition>();

    public QueryBuilder addFields(String ... fields) {
        this.fields.addAll(Arrays.asList(fields));
        return this;
    }

    public QueryBuilder addTableNames(String ... tableNames) {
        this.tableNames.addAll(Arrays.asList(tableNames));
        return this;
    }

    public QueryBuilder eq(String field, Object value) {
        return this.addCondition(new Condition(field, value));
    }

    public QueryBuilder ne(String field, Object value) {
        return this.addCondition(new Condition(field, "!=", value));
    }

    public QueryBuilder gt(String field, Object value) {
        return this.addCondition(new Condition(field, ">", value));
    }

    public QueryBuilder lt(String field, Object value) {
        return this.addCondition(new Condition(field, "<", value));
    }

    public QueryBuilder ge(String field, Object value) {
        return this.addCondition(new Condition(field, ">=", value));
    }

    public QueryBuilder le(String field, Object value) {
        return this.addCondition(new Condition(field, "<=", value));
    }

    public QueryBuilder like(String field, String value) {
        return this.addCondition(new Condition(field, value, Condition.LikeType.Contains));
    }

    public QueryBuilder likeStartWith(String field, String value) {
        return this.addCondition(new Condition(field, value, Condition.LikeType.StartWith));
    }

    public QueryBuilder likeEndWith(String field, String value) {
        return this.addCondition(new Condition(field, value, Condition.LikeType.EndWith));
    }

    public QueryBuilder in(String field, Object ... values) {
        return this.addCondition(new Condition(field, "IN", values));
    }

    public QueryBuilder in(String field, Iterable<?> values) {
        return this.addCondition(new Condition(field, "IN", values));
    }

    public QueryBuilder notIn(String field, Object ... values) {
        return this.addCondition(new Condition(field, "NOT IN", values));
    }

    public QueryBuilder notIn(String field, Iterable<?> values) {
        return this.addCondition(new Condition(field, "NOT IN", values));
    }

    public QueryBuilder between(String field, Object start, Object end) {
        return this.addCondition(new Condition(field, StrUtil.format((CharSequence)"BETWEEN {} AND {}", (Object[])new Object[]{start, end})));
    }

    public QueryBuilder notBetween(String field, Object start, Object end) {
        return this.addCondition(new Condition(field, StrUtil.format((CharSequence)"NOT BETWEEN {} AND {}", (Object[])new Object[]{start, end})));
    }

    public QueryBuilder addCondition(Condition condition) {
        this.wheres.add(condition);
        return this;
    }

    public Query build() {
        return new Query(this.fields, this.tableNames.toArray(new String[0]), this.wheres.toArray(new Condition[0]), null);
    }
}

