/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.Db;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.Page;
import org.dromara.hutool.db.PageResult;
import org.dromara.hutool.db.ds.DSUtil;

public class DaoTemplate {
    protected String tableName;
    protected String primaryKeyField = "id";
    protected Db db;

    public DaoTemplate(String tableName) {
        this(tableName, (String)null);
    }

    public DaoTemplate(String tableName, String primaryKeyField) {
        this(tableName, primaryKeyField, DSUtil.getDS());
    }

    public DaoTemplate(String tableName, DataSource ds) {
        this(tableName, null, ds);
    }

    public DaoTemplate(String tableName, String primaryKeyField, DataSource ds) {
        this(tableName, primaryKeyField, Db.of(ds));
    }

    public DaoTemplate(String tableName, String primaryKeyField, Db db) {
        this.tableName = tableName;
        if (StrUtil.isNotBlank((CharSequence)primaryKeyField)) {
            this.primaryKeyField = primaryKeyField;
        }
        this.db = db;
    }

    public int add(Entity entity) throws DbRuntimeException {
        return this.db.insert(this.fixEntity(entity));
    }

    public List<Object> addForGeneratedKeys(Entity entity) throws DbRuntimeException {
        return this.db.insertForGeneratedKeys(this.fixEntity(entity));
    }

    public Long addForGeneratedKey(Entity entity) throws DbRuntimeException {
        return this.db.insertForGeneratedKey(this.fixEntity(entity));
    }

    public <T> int del(T pk) throws DbRuntimeException {
        if (pk == null) {
            return 0;
        }
        return this.del(Entity.of(this.tableName).set(this.primaryKeyField, pk));
    }

    public <T> int del(String field, T value) throws DbRuntimeException {
        if (StrUtil.isBlank((CharSequence)field)) {
            return 0;
        }
        return this.del(Entity.of(this.tableName).set(field, value));
    }

    public int del(Entity where) throws DbRuntimeException {
        if (MapUtil.isEmpty((Map)((Object)where))) {
            return 0;
        }
        return this.db.del(this.fixEntity(where));
    }

    public int update(Entity record, Entity where) throws DbRuntimeException {
        if (MapUtil.isEmpty((Map)((Object)record))) {
            return 0;
        }
        return this.db.update(this.fixEntity(record), where);
    }

    public int update(Entity entity) throws DbRuntimeException {
        if (MapUtil.isEmpty((Map)((Object)entity))) {
            return 0;
        }
        Object pk = (entity = this.fixEntity(entity)).get(this.primaryKeyField);
        if (null == pk) {
            throw new DbRuntimeException(StrUtil.format((CharSequence)"Please determine `{}` for update", (Object[])new Object[]{this.primaryKeyField}));
        }
        Entity where = Entity.of(this.tableName).set(this.primaryKeyField, pk);
        Entity record = entity.clone();
        record.remove(this.primaryKeyField);
        return this.db.update(record, where);
    }

    public int addOrUpdate(Entity entity) throws DbRuntimeException {
        return null == entity.get(this.primaryKeyField) ? this.add(entity) : this.update(entity);
    }

    public <T> Entity get(T pk) throws DbRuntimeException {
        return this.get(this.primaryKeyField, pk);
    }

    public <T> Entity get(String field, T value) throws DbRuntimeException {
        return this.get(Entity.of(this.tableName).set(field, value));
    }

    public Entity get(Entity where) throws DbRuntimeException {
        return this.db.get(this.fixEntity(where));
    }

    public <T> List<Entity> find(String field, T value) throws DbRuntimeException {
        return this.find(Entity.of(this.tableName).set(field, value));
    }

    public List<Entity> findAll() throws DbRuntimeException {
        return this.find(Entity.of(this.tableName));
    }

    public List<Entity> find(Entity where) throws DbRuntimeException {
        return this.db.find(null, this.fixEntity(where));
    }

    public List<Entity> findBySql(String sql, Object ... params) throws DbRuntimeException {
        String selectKeyword = StrUtil.subPre((CharSequence)sql.trim(), (int)6).toLowerCase();
        if (!"select".equals(selectKeyword)) {
            sql = "SELECT * FROM " + this.tableName + " " + sql;
        }
        return this.db.query(sql, params);
    }

    public PageResult<Entity> page(Entity where, Page page, String ... selectFields) throws DbRuntimeException {
        return this.db.page(Arrays.asList(selectFields), this.fixEntity(where), page);
    }

    public PageResult<Entity> page(Entity where, Page page) throws DbRuntimeException {
        return this.db.page(this.fixEntity(where), page);
    }

    public long count(Entity where) throws DbRuntimeException {
        return this.db.count(this.fixEntity(where));
    }

    public boolean exist(Entity where) throws DbRuntimeException {
        return this.count(where) > 0L;
    }

    private Entity fixEntity(Entity entity) {
        if (null == entity) {
            entity = Entity.of(this.tableName);
        } else if (StrUtil.isBlank((CharSequence)entity.getTableName())) {
            entity.setTableName(this.tableName);
        }
        return entity;
    }
}

