/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.pooled;

import javax.sql.DataSource;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.ds.AbstractDSFactory;
import org.dromara.hutool.db.ds.DSKeys;
import org.dromara.hutool.db.ds.pooled.DbConfig;
import org.dromara.hutool.db.ds.pooled.PooledDataSource;
import org.dromara.hutool.setting.Setting;

public class PooledDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = 8093886210895248277L;
    public static final String DS_NAME = "Hutool-Pooled-DataSource";

    public PooledDSFactory() {
        this(null);
    }

    public PooledDSFactory(Setting setting) {
        super(DS_NAME, PooledDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        DbConfig dbConfig = new DbConfig();
        dbConfig.setUrl(jdbcUrl);
        dbConfig.setDriver(driver);
        dbConfig.setUser(user);
        dbConfig.setPass(pass);
        dbConfig.setInitialSize(poolSetting.getInt((Object)"initialSize", Integer.valueOf(0)));
        dbConfig.setMinIdle(poolSetting.getInt((Object)"minIdle", Integer.valueOf(0)));
        dbConfig.setMaxActive(poolSetting.getInt((Object)"maxActive", Integer.valueOf(8)));
        dbConfig.setMaxWait(poolSetting.getLong((Object)"maxWait", Long.valueOf(6000L)));
        for (String key : DSKeys.KEY_CONN_PROPS) {
            String connValue = poolSetting.get((Object)key);
            if (!StrUtil.isNotBlank((CharSequence)connValue)) continue;
            dbConfig.addConnProps(key, connValue);
        }
        return new PooledDataSource(dbConfig);
    }
}

