/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.ds.AbstractDSFactory;
import org.dromara.hutool.db.ds.DSKeys;
import org.dromara.hutool.setting.Setting;
import org.dromara.hutool.setting.props.Props;

public class HikariDSFactory
extends AbstractDSFactory {
    private static final long serialVersionUID = -8834744983614749401L;
    public static final String DS_NAME = "HikariCP";

    public HikariDSFactory() {
        this(null);
    }

    public HikariDSFactory(Setting setting) {
        super(DS_NAME, HikariDataSource.class, setting);
    }

    @Override
    protected DataSource createDataSource(String jdbcUrl, String driver, String user, String pass, Setting poolSetting) {
        Props connProps = new Props();
        for (String key : DSKeys.KEY_CONN_PROPS) {
            String connValue = poolSetting.getAndRemove(new String[]{key});
            if (!StrUtil.isNotBlank((CharSequence)connValue)) continue;
            connProps.setProperty(key, connValue);
        }
        Props config = new Props();
        config.putAll((Map)poolSetting);
        config.put((Object)"jdbcUrl", (Object)jdbcUrl);
        if (null != driver) {
            config.put((Object)"driverClassName", (Object)driver);
        }
        if (null != user) {
            config.put((Object)"username", (Object)user);
        }
        if (null != pass) {
            config.put((Object)"password", (Object)pass);
        }
        HikariConfig hikariConfig = new HikariConfig((Properties)config);
        hikariConfig.setDataSourceProperties((Properties)connProps);
        return new HikariDataSource(hikariConfig);
    }
}

