/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds.pooled;

import java.util.Map;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.dialect.DriverUtil;
import org.dromara.hutool.db.ds.DSKeys;
import org.dromara.hutool.db.ds.pooled.DbConfig;
import org.dromara.hutool.setting.Setting;

public class DbSetting {
    public static final String DEFAULT_DB_CONFIG_PATH = "config/db.setting";
    private final Setting setting;

    public DbSetting() {
        this(null);
    }

    public DbSetting(Setting setting) {
        this.setting = null == setting ? new Setting(DEFAULT_DB_CONFIG_PATH) : setting;
    }

    public DbConfig getDbConfig(String group) {
        Setting config = this.setting.getSetting(group);
        if (MapUtil.isEmpty((Map)config)) {
            throw new DbRuntimeException("No Hutool pool config for group: [{}]", group);
        }
        DbConfig dbConfig = new DbConfig();
        String url = config.getAndRemove(DSKeys.KEY_ALIAS_URL);
        if (StrUtil.isBlank((CharSequence)url)) {
            throw new DbRuntimeException("No JDBC URL for group: [{}]", group);
        }
        dbConfig.setUrl(url);
        String driver = config.getAndRemove(DSKeys.KEY_ALIAS_DRIVER);
        dbConfig.setDriver(StrUtil.isNotBlank((CharSequence)driver) ? driver : DriverUtil.identifyDriver(url));
        dbConfig.setUser(config.getAndRemove(DSKeys.KEY_ALIAS_USER));
        dbConfig.setPass(config.getAndRemove(DSKeys.KEY_ALIAS_PASSWORD));
        dbConfig.setInitialSize(this.setting.getIntByGroup((Object)"initialSize", (Object)group, Integer.valueOf(0)));
        dbConfig.setMinIdle(this.setting.getIntByGroup((Object)"minIdle", (Object)group, Integer.valueOf(0)));
        dbConfig.setMaxActive(this.setting.getIntByGroup((Object)"maxActive", (Object)group, Integer.valueOf(8)));
        dbConfig.setMaxWait(this.setting.getLongByGroup((Object)"maxWait", (Object)group, Long.valueOf(6000L)));
        for (String key : DSKeys.KEY_CONN_PROPS) {
            String connValue = config.get((Object)key);
            if (!StrUtil.isNotBlank((CharSequence)connValue)) continue;
            dbConfig.addConnProps(key, connValue);
        }
        return dbConfig;
    }
}

