/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.dromara.hutool.core.func.SerFunction;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.DefaultConnectionHolder;
import org.dromara.hutool.db.DialectRunner;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.GlobalDbConfig;
import org.dromara.hutool.db.Page;
import org.dromara.hutool.db.PageResult;
import org.dromara.hutool.db.dialect.Dialect;
import org.dromara.hutool.db.handler.BeanListHandler;
import org.dromara.hutool.db.handler.EntityHandler;
import org.dromara.hutool.db.handler.EntityListHandler;
import org.dromara.hutool.db.handler.NumberHandler;
import org.dromara.hutool.db.handler.PageResultHandler;
import org.dromara.hutool.db.handler.ResultSetUtil;
import org.dromara.hutool.db.handler.RsHandler;
import org.dromara.hutool.db.handler.StringHandler;
import org.dromara.hutool.db.sql.Condition;
import org.dromara.hutool.db.sql.Query;
import org.dromara.hutool.db.sql.QuoteWrapper;
import org.dromara.hutool.db.sql.SqlBuilder;
import org.dromara.hutool.db.sql.SqlExecutor;
import org.dromara.hutool.db.sql.SqlUtil;

public abstract class AbstractDb<R extends AbstractDb<R>>
extends DefaultConnectionHolder
implements Serializable {
    private static final long serialVersionUID = 3858951941916349062L;
    protected Boolean isSupportTransaction = null;
    protected boolean caseInsensitive = GlobalDbConfig.caseInsensitive;
    protected DialectRunner runner;

    public AbstractDb(DataSource ds, Dialect dialect) {
        super(ds);
        this.runner = new DialectRunner(dialect);
    }

    public List<Entity> query(String sql, Map<String, Object> params) throws DbRuntimeException {
        return this.query(sql, new EntityListHandler(this.caseInsensitive), params);
    }

    public List<Entity> query(String sql, Object ... params) throws DbRuntimeException {
        return this.query(sql, new EntityListHandler(this.caseInsensitive), params);
    }

    public <T> List<T> query(String sql, Class<T> beanClass, Object ... params) throws DbRuntimeException {
        return (List)this.query(sql, new BeanListHandler<T>(beanClass), params);
    }

    public Entity queryOne(String sql, Object ... params) throws DbRuntimeException {
        return this.query(sql, new EntityHandler(this.caseInsensitive), params);
    }

    public Number queryNumber(String sql, Object ... params) throws DbRuntimeException {
        return this.query(sql, new NumberHandler(), params);
    }

    public String queryString(String sql, Object ... params) throws DbRuntimeException {
        return this.query(sql, new StringHandler(), params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(String sql, RsHandler<T> rsh, Object ... params) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = SqlExecutor.query(conn, sql, rsh, params);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(String sql, RsHandler<T> rsh, Map<String, Object> paramMap) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = SqlExecutor.query(conn, sql, rsh, paramMap);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T query(SerFunction<Connection, PreparedStatement> statementFunc, RsHandler<T> rsh) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = SqlExecutor.query(conn, statementFunc, rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute(String sql, Object ... params) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = SqlExecutor.execute(conn, sql, params);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long executeForGeneratedKey(String sql, Object ... params) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            Long l = SqlExecutor.executeForGeneratedKey(conn, sql, params);
            return l;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(String sql, Iterable<Object[]> paramsBatch) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = SqlExecutor.executeBatch(conn, sql, paramsBatch);
            return nArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(String ... sqls) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = SqlExecutor.executeBatch(conn, sqls);
            return nArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch(Iterable<String> sqls) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = SqlExecutor.executeBatch(conn, sqls);
            return nArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insert(Entity record) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.insert(conn, record)[0];
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertOrUpdate(Entity record, String ... keys) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.insertOrUpdate(conn, record, keys);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int upsert(Entity record, String ... keys) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.upsert(conn, record, keys);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] insert(Collection<Entity> records) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int[] nArray = this.runner.insert(conn, records.toArray(new Entity[0]));
            return nArray;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> insertForGeneratedKeys(Entity record) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            List list = this.runner.insert(conn, record, ResultSetUtil::handleRowToList);
            return list;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long insertForGeneratedKey(Entity record) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            Long l = this.runner.insert(conn, record, ResultSetUtil::toLong);
            return l;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public int del(String tableName, String field, Object value) throws DbRuntimeException {
        return this.del(Entity.of(tableName).set(field, value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int del(Entity where) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.del(conn, where);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(Entity record, Entity where) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            int n = this.runner.update(conn, record, where);
            return n;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> Entity get(String tableName, String field, T value) throws DbRuntimeException {
        return this.get(Entity.of(tableName).set(field, value));
    }

    public Entity get(Entity where) throws DbRuntimeException {
        return this.find(where.getFieldNames(), where, new EntityHandler(this.caseInsensitive));
    }

    public <T> T find(Collection<String> fields, Entity where, RsHandler<T> rsh) throws DbRuntimeException {
        return this.find(Query.of(where).setFields(fields), rsh);
    }

    public List<Entity> find(Collection<String> fields, Entity where) throws DbRuntimeException {
        return this.find(fields, where, new EntityListHandler(this.caseInsensitive));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Query query, RsHandler<T> rsh) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.find(conn, query, rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> T find(Entity where, RsHandler<T> rsh, String ... fields) throws DbRuntimeException {
        return this.find(Arrays.asList(fields), where, rsh);
    }

    public List<Entity> find(Entity where) throws DbRuntimeException {
        return this.find(where.getFieldNames(), where, new EntityListHandler(this.caseInsensitive));
    }

    public <T> List<T> find(Entity where, Class<T> beanClass) throws DbRuntimeException {
        return (List)this.find(where.getFieldNames(), where, BeanListHandler.of(beanClass));
    }

    public List<Entity> findAll(Entity where) throws DbRuntimeException {
        return this.find(where, new EntityListHandler(this.caseInsensitive), new String[0]);
    }

    public <T> List<T> findAll(Entity where, Class<T> beanClass) throws DbRuntimeException {
        return (List)this.find(where, BeanListHandler.of(beanClass), new String[0]);
    }

    public List<Entity> findAll(String tableName) throws DbRuntimeException {
        return this.findAll(Entity.of(tableName));
    }

    public List<Entity> findBy(String tableName, String field, Object value) throws DbRuntimeException {
        return this.findAll(Entity.of(tableName).set(field, value));
    }

    public List<Entity> findBy(String tableName, Condition ... wheres) throws DbRuntimeException {
        Query query = new Query(wheres, tableName);
        return this.find(query, new EntityListHandler(this.caseInsensitive));
    }

    public List<Entity> findLike(String tableName, String field, String value, Condition.LikeType likeType) throws DbRuntimeException {
        return this.findAll(Entity.of(tableName).set(field, SqlUtil.buildLikeValue(value, likeType, true)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(Entity where) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            long l = this.runner.count(conn, Query.of(where));
            return l;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(SqlBuilder sql) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            long l = this.runner.count(conn, sql);
            return l;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(CharSequence selectSql, Object ... params) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            long l = this.runner.count(conn, SqlBuilder.of(selectSql).addParams(params));
            return l;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public <T> PageResult<T> pageForBeanResult(CharSequence sql, Page page, Class<T> elementBeanType, Object ... params) {
        PageResult result = new PageResult(page, (int)this.count(sql, params));
        return (PageResult)this.page(sql, page, PageResultHandler.of(elementBeanType, result), params);
    }

    public <T> List<T> pageForBeanList(CharSequence sql, Page page, Class<T> elementBeanType, Object ... params) {
        return (List)this.page(sql, page, BeanListHandler.of(elementBeanType), params);
    }

    public List<Entity> pageForEntityList(Entity where, Page page) throws DbRuntimeException {
        return this.page(where, page, new EntityListHandler(this.caseInsensitive));
    }

    public <T> T page(Entity where, Page page, RsHandler<T> rsh) throws DbRuntimeException {
        return this.page(where.getFieldNames(), where, page, rsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T page(Collection<String> fields, Entity where, Page page, RsHandler<T> rsh) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.page(conn, Query.of(where).setFields(fields).setPage(page), rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T page(CharSequence sql, Page page, RsHandler<T> rsh, Object ... params) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.page(conn, SqlBuilder.of(sql).addParams(params), page, rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T page(SqlBuilder sql, Page page, RsHandler<T> rsh) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            T t = this.runner.page(conn, sql, page, rsh);
            return t;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageResult<Entity> page(CharSequence sql, Page page, Object ... params) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            PageResult<Entity> pageResult = this.runner.page(conn, SqlBuilder.of(sql).addParams(params), page);
            return pageResult;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public PageResult<Entity> page(Collection<String> fields, Entity where, int pageNumber, int pageSize) throws DbRuntimeException {
        return this.page(fields, where, new Page(pageNumber, pageSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PageResult<Entity> page(Collection<String> fields, Entity where, Page page) throws DbRuntimeException {
        Connection conn = null;
        try {
            conn = this.getConnection();
            PageResult<Entity> pageResult = this.runner.page(conn, Query.of(where).setFields(fields).setPage(page));
            return pageResult;
        }
        finally {
            this.closeConnection(conn);
        }
    }

    public PageResult<Entity> page(Entity where, Page page) throws DbRuntimeException {
        return this.page(where.getFieldNames(), where, page);
    }

    public R setCaseInsensitive(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        return (R)this;
    }

    public DialectRunner getRunner() {
        return this.runner;
    }

    public R setRunner(DialectRunner runner) {
        this.runner = runner;
        return (R)this;
    }

    public R setWrapper(Character wrapperChar) {
        return this.setWrapper(new QuoteWrapper(wrapperChar));
    }

    public R setWrapper(QuoteWrapper quoteWrapper) {
        this.runner.setWrapper(quoteWrapper);
        return (R)this;
    }

    public R disableWrapper() {
        return this.setWrapper((QuoteWrapper)null);
    }

    protected void checkTransactionSupported(Connection conn) throws DbRuntimeException {
        if (null == this.isSupportTransaction) {
            try {
                this.isSupportTransaction = conn.getMetaData().supportsTransactions();
            }
            catch (SQLException e) {
                throw new DbRuntimeException(e);
            }
        }
        if (!this.isSupportTransaction.booleanValue()) {
            throw new DbRuntimeException("Transaction not supported for current database!");
        }
    }
}

