/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db;

import java.io.Serializable;
import java.util.Arrays;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.lang.page.PageInfo;
import org.dromara.hutool.core.lang.range.Segment;
import org.dromara.hutool.db.sql.Order;

public class Page
implements Segment<Integer>,
Serializable {
    private static final long serialVersionUID = 97792549823353462L;
    public static final int DEFAULT_PAGE_SIZE = 20;
    private int pageNumber;
    private int pageSize;
    private Order[] orders;

    public static Page of(int pageNumber, int pageSize) {
        return new Page(pageNumber, pageSize);
    }

    public Page() {
        this(0, 20);
    }

    public Page(int pageNumber, int pageSize) {
        this.pageNumber = Math.max(pageNumber, 0);
        this.pageSize = pageSize <= 0 ? 20 : pageSize;
    }

    public Page(int pageNumber, int pageSize, Order order) {
        this(pageNumber, pageSize);
        this.orders = new Order[]{order};
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = Math.max(pageNumber, 0);
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize <= 0 ? 20 : pageSize;
    }

    public Order[] getOrders() {
        return this.orders;
    }

    public void setOrder(Order ... orders) {
        this.orders = orders;
    }

    public void addOrder(Order ... orders) {
        this.orders = (Order[])ArrayUtil.append((Object[])this.orders, (Object[])orders);
    }

    public int getStartPosition() {
        return this.getBeginIndex();
    }

    public Integer getBeginIndex() {
        return PageInfo.of((int)Integer.MAX_VALUE, (int)this.pageSize).setFirstPageNo(0).setPageNo(this.pageNumber).getBeginIndex();
    }

    public int getEndPosition() {
        return this.getEndIndex();
    }

    public Integer getEndIndex() {
        return PageInfo.of((int)Integer.MAX_VALUE, (int)this.pageSize).setFirstPageNo(0).getEndIndex();
    }

    public int[] getStartEnd() {
        PageInfo pageInfo = PageInfo.of((int)Integer.MAX_VALUE, (int)this.pageSize).setFirstPageNo(0).setPageNo(this.pageNumber);
        return new int[]{pageInfo.getBeginIndex(), pageInfo.getEndIndexExclude()};
    }

    public String toString() {
        return "Page [page=" + this.pageNumber + ", pageSize=" + this.pageSize + ", order=" + Arrays.toString(this.orders) + "]";
    }
}

