/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds;

import java.util.Collection;
import java.util.Map;
import javax.sql.DataSource;
import org.dromara.hutool.core.lang.Assert;
import org.dromara.hutool.core.map.MapUtil;
import org.dromara.hutool.core.map.SafeConcurrentHashMap;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.DbUtil;
import org.dromara.hutool.db.GlobalDbConfig;
import org.dromara.hutool.db.dialect.DriverUtil;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.ds.DSKeys;
import org.dromara.hutool.db.ds.DSWrapper;
import org.dromara.hutool.setting.Setting;

public abstract class AbstractDSFactory
implements DSFactory {
    private static final long serialVersionUID = -6407302276272379881L;
    protected final String dataSourceName;
    private final Setting setting;
    private final Map<String, DSWrapper> dsMap;

    public AbstractDSFactory(String dataSourceName, Class<? extends DataSource> dataSourceClass, Setting setting) {
        Assert.notNull(dataSourceClass);
        this.dataSourceName = dataSourceName;
        if (null == setting) {
            setting = GlobalDbConfig.createDbSetting();
        }
        DbUtil.setShowSqlGlobal(setting);
        this.setting = setting;
        this.dsMap = new SafeConcurrentHashMap();
    }

    public Setting getSetting() {
        return this.setting;
    }

    @Override
    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public DataSource getDataSource(String group) {
        if (group == null) {
            group = "";
        }
        return this.dsMap.computeIfAbsent(group, this::_createDataSource);
    }

    @Override
    public synchronized void closeDataSource(String group) {
        DSWrapper ds;
        if (group == null) {
            group = "";
        }
        if ((ds = this.dsMap.get(group)) != null) {
            ds.close();
            this.dsMap.remove(group);
        }
    }

    @Override
    public void close() {
        if (MapUtil.isNotEmpty(this.dsMap)) {
            Collection<DSWrapper> values = this.dsMap.values();
            for (DSWrapper ds : values) {
                ds.close();
            }
            this.dsMap.clear();
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dataSourceName == null ? 0 : this.dataSourceName.hashCode());
        result = 31 * result + (this.setting == null ? 0 : this.setting.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractDSFactory other = (AbstractDSFactory)obj;
        if (this.dataSourceName == null ? other.dataSourceName != null : !this.dataSourceName.equals(other.dataSourceName)) {
            return false;
        }
        if (this.setting == null) {
            return other.setting == null;
        }
        return this.setting.equals((Object)other.setting);
    }

    protected abstract DataSource createDataSource(String var1, String var2, String var3, String var4, Setting var5);

    private DSWrapper _createDataSource(String group) {
        Setting config;
        if (group == null) {
            group = "";
        }
        if (MapUtil.isEmpty((Map)(config = this.setting.getSetting(group)))) {
            throw new DbRuntimeException("No config for group: [{}]", group);
        }
        String url = config.getAndRemove(DSKeys.KEY_ALIAS_URL);
        if (StrUtil.isBlank((CharSequence)url)) {
            throw new DbRuntimeException("No JDBC URL for group: [{}]", group);
        }
        AbstractDSFactory.removeShowSqlParams(config);
        String driver = config.getAndRemove(DSKeys.KEY_ALIAS_DRIVER);
        if (StrUtil.isBlank((CharSequence)driver)) {
            driver = DriverUtil.identifyDriver(url);
        }
        String user = config.getAndRemove(DSKeys.KEY_ALIAS_USER);
        String pass = config.getAndRemove(DSKeys.KEY_ALIAS_PASSWORD);
        return DSWrapper.wrap(this.createDataSource(url, driver, user, pass, config), driver);
    }

    private static void removeShowSqlParams(Setting setting) {
        setting.remove((Object)"showSql");
        setting.remove((Object)"formatSql");
        setting.remove((Object)"showParams");
        setting.remove((Object)"sqlLevel");
    }
}

