/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds;

import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.util.RuntimeUtil;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.ds.DSUtil;
import org.dromara.hutool.log.LogUtil;

public class GlobalDSFactory {
    private static volatile DSFactory factory;
    private static final Object lock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSFactory get() {
        if (null == factory) {
            Object object = lock;
            synchronized (object) {
                if (null == factory) {
                    factory = DSUtil.createFactory(null);
                }
            }
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DSFactory set(DSFactory customDSFactory) {
        Object object = lock;
        synchronized (object) {
            if (null != factory) {
                if (factory.equals(customDSFactory)) {
                    return factory;
                }
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{factory});
            }
            LogUtil.debug((String)"Custom use [{}] DataSource.", (Object[])new Object[]{customDSFactory.getDataSourceName()});
            factory = customDSFactory;
        }
        return factory;
    }

    static {
        lock = new Object();
        RuntimeUtil.addShutdownHook(() -> {
            if (null != factory) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{factory});
                LogUtil.debug((String)"DataSource: [{}] closed.", (Object[])new Object[]{factory.getDataSourceName()});
                factory = null;
            }
        });
    }
}

