/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.sql;

import java.util.ArrayList;
import java.util.List;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.lang.builder.Builder;
import org.dromara.hutool.db.sql.Condition;

public class ConditionBuilder
implements Builder<String> {
    private static final long serialVersionUID = 1L;
    private final Condition[] conditions;
    private List<Object> paramValues;

    public static ConditionBuilder of(Condition ... conditions) {
        return new ConditionBuilder(conditions);
    }

    public ConditionBuilder(Condition ... conditions) {
        this.conditions = conditions;
    }

    public List<Object> getParamValues() {
        return ListUtil.view(this.paramValues);
    }

    public String build() {
        if (null == this.paramValues) {
            this.paramValues = new ArrayList<Object>();
        } else {
            this.paramValues.clear();
        }
        return this.build(this.paramValues);
    }

    public String build(List<Object> paramValues) {
        if (ArrayUtil.isEmpty((Object[])this.conditions)) {
            return "";
        }
        StringBuilder conditionStrBuilder = new StringBuilder();
        boolean isFirst = true;
        for (Condition condition : this.conditions) {
            if (isFirst) {
                isFirst = false;
            } else {
                conditionStrBuilder.append(' ').append((Object)condition.getLinkOperator()).append(' ');
            }
            conditionStrBuilder.append(condition.toString(paramValues));
        }
        return conditionStrBuilder.toString();
    }

    public String toString() {
        return this.build();
    }
}

