/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.ds;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.dromara.hutool.core.reflect.ConstructorUtil;
import org.dromara.hutool.core.spi.ListServiceLoader;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.GlobalDbConfig;
import org.dromara.hutool.db.ds.DSFactory;
import org.dromara.hutool.db.ds.GlobalDSFactory;
import org.dromara.hutool.log.StaticLog;
import org.dromara.hutool.setting.Setting;

public class DSUtil {
    public static DataSource getJndiDSWithLog(String jndiName) {
        try {
            return DSUtil.getJndiDS(jndiName);
        }
        catch (DbRuntimeException e) {
            StaticLog.error((Throwable)e.getCause(), (String)"Find JNDI datasource error!", (Object[])new Object[0]);
            return null;
        }
    }

    public static DataSource getJndiDS(String jndiName) {
        try {
            return (DataSource)new InitialContext().lookup(jndiName);
        }
        catch (NamingException e) {
            throw new DbRuntimeException(e);
        }
    }

    public static DataSource getDS() {
        return DSUtil.getDS(null);
    }

    public static DataSource getDS(String group) {
        return GlobalDSFactory.get().getDataSource(group);
    }

    public static DSFactory setGlobalDSFactory(DSFactory dsFactory) {
        return GlobalDSFactory.set(dsFactory);
    }

    public static DSFactory createFactory(Setting setting) {
        DSFactory dsFactory = DSUtil._createFactory(setting);
        StaticLog.debug((String)"Use [{}] DataSource As Default.", (Object[])new Object[]{dsFactory.getDataSourceName()});
        return dsFactory;
    }

    private static DSFactory _createFactory(Setting setting) {
        if (null == setting) {
            setting = GlobalDbConfig.createDbSetting();
        }
        ListServiceLoader loader = ListServiceLoader.of(DSFactory.class);
        int size = loader.size();
        for (int i = 0; i < size; ++i) {
            try {
                return (DSFactory)ConstructorUtil.newInstance((Class)loader.getServiceClass(i), (Object[])new Object[]{setting});
            }
            catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
                continue;
            }
        }
        throw new DbRuntimeException("No DSFactory implement available!");
    }
}

