/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.db.meta;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.sql.DataSource;
import org.dromara.hutool.core.collection.ListUtil;
import org.dromara.hutool.core.convert.Convert;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.db.DbRuntimeException;
import org.dromara.hutool.db.Entity;
import org.dromara.hutool.db.meta.Column;
import org.dromara.hutool.db.meta.ColumnIndexInfo;
import org.dromara.hutool.db.meta.IndexInfo;
import org.dromara.hutool.db.meta.Table;
import org.dromara.hutool.db.meta.TableType;

public class MetaUtil {
    public static List<String> getTables(DataSource ds) {
        return MetaUtil.getTables(ds, TableType.TABLE);
    }

    public static List<String> getTables(DataSource ds, TableType ... types) {
        return MetaUtil.getTables(ds, null, null, types);
    }

    public static List<String> getTables(DataSource ds, String schema, TableType ... types) {
        return MetaUtil.getTables(ds, schema, null, types);
    }

    public static List<String> getTables(DataSource ds, String schema, String tableName, TableType ... types) {
        ArrayList<String> tables = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = ds.getConnection();
            String catalog = MetaUtil.getCatalog(conn);
            if (null == schema) {
                schema = MetaUtil.getSchema(conn);
            }
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getTables(catalog, schema, tableName, Convert.toStrArray((Object)types));){
                if (null != rs) {
                    while (rs.next()) {
                        String table = rs.getString("TABLE_NAME");
                        if (!StrUtil.isNotBlank((CharSequence)table)) continue;
                        tables.add(table);
                    }
                }
            }
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get tables error!", e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{conn});
        return tables;
    }

    public static String[] getColumnNames(ResultSet rs) throws DbRuntimeException {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            String[] labelNames = new String[columnCount];
            for (int i = 0; i < labelNames.length; ++i) {
                labelNames[i] = rsmd.getColumnLabel(i + 1);
            }
            return labelNames;
        }
        catch (Exception e) {
            throw new DbRuntimeException("Get colunms error!", e);
        }
    }

    public static String[] getColumnNames(DataSource ds, String tableName) {
        String[] stringArray;
        ArrayList<String> columnNames = new ArrayList<String>();
        Connection conn = null;
        try {
            conn = ds.getConnection();
            String catalog = MetaUtil.getCatalog(conn);
            String schema = MetaUtil.getSchema(conn);
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getColumns(catalog, schema, tableName, null);){
                if (null != rs) {
                    while (rs.next()) {
                        columnNames.add(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            stringArray = columnNames.toArray(new String[0]);
        }
        catch (Exception e) {
            try {
                throw new DbRuntimeException("Get columns error!", e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{conn});
        return stringArray;
    }

    public static Entity createLimitedEntity(DataSource ds, String tableName) {
        String[] columnNames = MetaUtil.getColumnNames(ds, tableName);
        return Entity.of(tableName).setFieldNames(columnNames);
    }

    public static Table getTableMeta(DataSource ds, String tableName) {
        return MetaUtil.getTableMeta(ds, null, null, tableName);
    }

    public static Table getTableMeta(DataSource ds, String catalog, String schema, String tableName) {
        Table table = Table.of(tableName);
        Connection conn = null;
        try {
            conn = ds.getConnection();
            if (null == catalog) {
                catalog = MetaUtil.getCatalog(conn);
            }
            table.setCatalog(catalog);
            if (null == schema) {
                schema = MetaUtil.getSchema(conn);
            }
            table.setSchema(schema);
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet rs = metaData.getTables(catalog, schema, tableName, new String[]{TableType.TABLE.value()});){
                if (null != rs && rs.next()) {
                    table.setComment(rs.getString("REMARKS"));
                }
            }
            rs = metaData.getPrimaryKeys(catalog, schema, tableName);
            var8_9 = null;
            try {
                if (null != rs) {
                    while (rs.next()) {
                        table.addPk(rs.getString("COLUMN_NAME"));
                    }
                }
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var8_9 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            rs = metaData.getColumns(catalog, schema, tableName, null);
            var8_9 = null;
            try {
                if (null != rs) {
                    while (rs.next()) {
                        table.setColumn(Column.of(table, rs));
                    }
                }
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var8_9 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
            rs = metaData.getIndexInfo(catalog, schema, tableName, false, false);
            var8_9 = null;
            try {
                LinkedHashMap<String, IndexInfo> indexInfoMap = new LinkedHashMap<String, IndexInfo>();
                if (null != rs) {
                    while (rs.next()) {
                        if (0 == rs.getShort("TYPE")) continue;
                        String indexName = rs.getString("INDEX_NAME");
                        String key = StrUtil.join((CharSequence)"&", (Object[])new Object[]{tableName, indexName});
                        IndexInfo indexInfo = (IndexInfo)indexInfoMap.get(key);
                        if (null == indexInfo) {
                            indexInfo = new IndexInfo(rs.getBoolean("NON_UNIQUE"), indexName, tableName, schema, catalog);
                            indexInfoMap.put(key, indexInfo);
                        }
                        indexInfo.getColumnIndexInfoList().add(ColumnIndexInfo.of(rs));
                    }
                }
                table.setIndexInfoList(ListUtil.of(indexInfoMap.values()));
            }
            catch (Throwable throwable) {
                var8_9 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var8_9 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var8_9.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            try {
                throw new DbRuntimeException("Get columns error!", e);
            }
            catch (Throwable throwable) {
                IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{conn});
                throw throwable;
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{conn});
        return table;
    }

    public static String getCatalog(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getCatalog();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public static String getSchema(Connection conn) {
        if (null == conn) {
            return null;
        }
        try {
            return conn.getSchema();
        }
        catch (SQLException sQLException) {
            return null;
        }
    }
}

