/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.extra.compress.archiver;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.SeekableByteChannel;
import java.util.function.Predicate;
import org.apache.commons.compress.archivers.sevenz.SevenZOutputFile;
import org.apache.commons.compress.utils.SeekableInMemoryByteChannel;
import org.dromara.hutool.core.array.ArrayUtil;
import org.dromara.hutool.core.io.IORuntimeException;
import org.dromara.hutool.core.io.IoUtil;
import org.dromara.hutool.core.io.file.FileUtil;
import org.dromara.hutool.core.text.StrUtil;
import org.dromara.hutool.extra.compress.archiver.Archiver;

public class SevenZArchiver
implements Archiver {
    private final SevenZOutputFile sevenZOutputFile;
    private SeekableByteChannel channel;
    private OutputStream out;

    public SevenZArchiver(File file) {
        try {
            this.sevenZOutputFile = new SevenZOutputFile(file);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public SevenZArchiver(OutputStream out) {
        this.out = out;
        this.channel = new SeekableInMemoryByteChannel();
        try {
            this.sevenZOutputFile = new SevenZOutputFile(this.channel);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public SevenZArchiver(SeekableByteChannel channel) {
        try {
            this.sevenZOutputFile = new SevenZOutputFile(channel);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    public SevenZOutputFile getSevenZOutputFile() {
        return this.sevenZOutputFile;
    }

    @Override
    public SevenZArchiver add(File file, String path, Predicate<File> filter) {
        try {
            this.addInternal(file, path, filter);
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    @Override
    public SevenZArchiver finish() {
        try {
            this.sevenZOutputFile.finish();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
        return this;
    }

    @Override
    public void close() {
        try {
            this.finish();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (null != this.out && this.channel instanceof SeekableInMemoryByteChannel) {
            try {
                this.out.write(((SeekableInMemoryByteChannel)this.channel).array());
            }
            catch (IOException e) {
                throw new IORuntimeException((Throwable)e);
            }
        }
        IoUtil.closeQuietly((AutoCloseable[])new AutoCloseable[]{this.sevenZOutputFile});
    }

    private void addInternal(File file, String path, Predicate<File> filter) throws IOException {
        if (null != filter && !filter.test(file)) {
            return;
        }
        SevenZOutputFile out = this.sevenZOutputFile;
        String entryName = StrUtil.isNotEmpty((CharSequence)path) ? StrUtil.addSuffixIfNot((CharSequence)path, (CharSequence)"/") + file.getName() : file.getName();
        out.putArchiveEntry(out.createArchiveEntry(file, entryName));
        if (file.isDirectory()) {
            Object[] files = file.listFiles();
            if (ArrayUtil.isNotEmpty((Object[])files)) {
                for (Object childFile : files) {
                    this.addInternal((File)childFile, entryName, filter);
                }
            }
        } else {
            if (file.isFile()) {
                out.write(FileUtil.readBytes((File)file));
            }
            out.closeArchiveEntry();
        }
    }
}

